/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.isolated;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.binary.Binary;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.gradle.DefaultRewriteExtension;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.GradleProjectParser;
import org.openrewrite.gradle.RewriteExtension;
import org.openrewrite.gradle.TimeUtils;
import org.openrewrite.gradle.isolated.ResourceParser;
import org.openrewrite.gradle.isolated.ResultsContainer;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.style.Autodetect;
import org.openrewrite.java.style.CheckstyleConfigLoader;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.shaded.jgit.api.Git;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParsingExecutionContextView;

public class DefaultProjectParser
implements GradleProjectParser {
    private static final JavaTypeCache javaTypeCache = new JavaTypeCache();
    private final Logger logger = Logging.getLogger(DefaultProjectParser.class);
    protected final Path baseDir;
    protected final RewriteExtension extension;
    protected final Project project;
    private final List<Marker> sharedProvenance;
    private final Map<String, Object> astCache;
    private List<NamedStyles> styles;
    private Environment environment;

    public DefaultProjectParser(Project project, RewriteExtension extension, Map<String, Object> astCache) {
        this.baseDir = project.getRootProject().getProjectDir().toPath();
        this.extension = extension;
        this.project = project;
        this.astCache = astCache;
        BuildEnvironment buildEnvironment = BuildEnvironment.build(System::getenv);
        this.sharedProvenance = Stream.of(buildEnvironment, this.gitProvenance(this.baseDir, buildEnvironment), new BuildTool(Tree.randomId(), BuildTool.Type.Gradle, project.getGradle().getGradleVersion())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private GitProvenance gitProvenance(Path baseDir, @Nullable BuildEnvironment buildEnvironment) {
        try {
            return GitProvenance.fromProjectDirectory((Path)baseDir, (BuildEnvironment)buildEnvironment);
        }
        catch (Exception e) {
            this.logger.debug("Unable to determine git provenance", (Throwable)e);
            return null;
        }
    }

    @Override
    public SortedSet<String> getActiveRecipes() {
        String activeRecipeProp = System.getProperty("activeRecipe");
        if (activeRecipeProp == null) {
            return new TreeSet<String>(this.extension.getActiveRecipes());
        }
        return new TreeSet<String>(Collections.singleton(activeRecipeProp));
    }

    @Override
    public SortedSet<String> getActiveStyles() {
        String activeStyleProp = System.getProperty("activeStyle");
        if (activeStyleProp == null) {
            return new TreeSet<String>(this.extension.getActiveStyles());
        }
        return new TreeSet<String>(Collections.singleton(activeStyleProp));
    }

    @Override
    public SortedSet<String> getAvailableStyles() {
        return this.environment().listStyles().stream().map(NamedStyles::getName).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.environment().listRecipeDescriptors();
    }

    @Override
    public Collection<Path> listSources(Project project) {
        TreeSet<Path> result;
        ResourceParser rp = new ResourceParser(this.baseDir, project, this.extension);
        try {
            result = new TreeSet<Path>(rp.listSources(project.getProjectDir().toPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaConvention != null) {
            for (SourceSet sourceSet : javaConvention.getSourceSets()) {
                sourceSet.getAllJava().getFiles().stream().filter(it -> it.isFile() && it.getName().endsWith(".java")).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).forEach(result::add);
            }
        }
        return result;
    }

    @Override
    public void dryRun(Path reportPath, boolean dumpGcActivity, boolean useAstCache, Consumer<Throwable> onError) {
        ParsingExecutionContextView ctx = ParsingExecutionContextView.view((ExecutionContext)new InMemoryExecutionContext(onError));
        if (dumpGcActivity) {
            SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
            new JvmHeapPressureMetrics().bindTo((MeterRegistry)meterRegistry);
            new JvmMemoryMetrics().bindTo((MeterRegistry)meterRegistry);
            File rewriteBuildDir = new File(this.project.getBuildDir(), "/rewrite");
            if (rewriteBuildDir.exists() || rewriteBuildDir.mkdirs()) {
                File rewriteGcLog = new File(rewriteBuildDir, "rewrite-gc.csv");
                try (FileOutputStream fos = new FileOutputStream(rewriteGcLog, false);
                     BufferedWriter logWriter = new BufferedWriter(new PrintWriter(fos));){
                    logWriter.write("file,jvm.gc.overhead,g1.old.gen.size\n");
                    ctx.setParsingListener((input, sourceFile) -> {
                        try {
                            logWriter.write(input.getPath() + ",");
                            logWriter.write(meterRegistry.get("jvm.gc.overhead").gauge().value() + ",");
                            Gauge g1Used = meterRegistry.find("jvm.memory.used").tag("id", "G1 Old Gen").gauge();
                            logWriter.write((g1Used == null ? "" : Double.toString(g1Used.value())) + "\n");
                        }
                        catch (IOException e) {
                            this.logger.error("Unable to write rewrite GC log");
                            throw new UncheckedIOException(e);
                        }
                    });
                    this.dryRun(reportPath, this.listResults(useAstCache, (ExecutionContext)ctx));
                    logWriter.flush();
                    this.logger.lifecycle("Wrote rewrite GC log: {}", new Object[]{rewriteGcLog.getAbsolutePath()});
                }
                catch (IOException e) {
                    this.logger.error("Unable to write rewrite GC log", (Throwable)e);
                    throw new UncheckedIOException(e);
                }
            }
        } else {
            this.dryRun(reportPath, this.listResults(useAstCache, (ExecutionContext)ctx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dryRun(Path reportPath, ResultsContainer results) {
        block23: {
            try {
                if (results.isNotEmpty()) {
                    for (Result result : results.generated) {
                        assert (result.getAfter() != null);
                        this.logger.warn("These recipes would generate new file {}:", (Object)result.getAfter().getSourcePath());
                        this.logRecipesThatMadeChanges(result);
                    }
                    for (Result result : results.deleted) {
                        assert (result.getBefore() != null);
                        this.logger.warn("These recipes would delete file {}:", (Object)result.getBefore().getSourcePath());
                        this.logRecipesThatMadeChanges(result);
                    }
                    for (Result result : results.moved) {
                        assert (result.getBefore() != null);
                        assert (result.getAfter() != null);
                        this.logger.warn("These recipes would move file from {} to {}:", (Object)result.getBefore().getSourcePath(), (Object)result.getAfter().getSourcePath());
                        this.logRecipesThatMadeChanges(result);
                    }
                    for (Result result : results.refactoredInPlace) {
                        assert (result.getBefore() != null);
                        this.logger.warn("These recipes would make results to {}:", (Object)result.getBefore().getSourcePath());
                        this.logRecipesThatMadeChanges(result);
                    }
                    reportPath.getParent().toFile().mkdirs();
                    try (BufferedWriter writer = Files.newBufferedWriter(reportPath, new OpenOption[0]);){
                        Stream.concat(Stream.concat(results.generated.stream(), results.deleted.stream()), Stream.concat(results.moved.stream(), results.refactoredInPlace.stream())).map(Result::diff).forEach(diff -> {
                            try {
                                writer.write(diff + "\n");
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to generate rewrite result file.", e);
                    }
                    this.logger.warn("Report available:");
                    this.logger.warn("    " + reportPath.normalize());
                    this.logger.warn("Run 'gradle rewriteRun' to apply the recipes.");
                    if (((DefaultRewriteExtension)this.project.getExtensions().getByType(DefaultRewriteExtension.class)).getFailOnDryRunResults()) {
                        throw new RuntimeException("Applying recipes would make changes. See logs for more details.");
                    }
                    break block23;
                }
                this.logger.lifecycle("Applying recipes would make no changes. No report generated.");
            }
            finally {
                this.shutdownRewrite();
            }
        }
    }

    @Override
    public void run(boolean useAstCache, Consumer<Throwable> onError) {
        this.run(this.listResults(useAstCache, (ExecutionContext)new InMemoryExecutionContext(onError)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ResultsContainer results) {
        block26: {
            try {
                if (!results.isNotEmpty()) break block26;
                for (Result result : results.generated) {
                    assert (result.getAfter() != null);
                    this.logger.lifecycle("Generated new file " + result.getAfter().getSourcePath() + " by:");
                    this.logRecipesThatMadeChanges(result);
                }
                for (Result result : results.deleted) {
                    assert (result.getBefore() != null);
                    this.logger.lifecycle("Deleted file " + result.getBefore().getSourcePath() + " by:");
                    this.logRecipesThatMadeChanges(result);
                }
                for (Result result : results.moved) {
                    assert (result.getAfter() != null);
                    assert (result.getBefore() != null);
                    this.logger.lifecycle("File has been moved from " + result.getBefore().getSourcePath() + " to " + result.getAfter().getSourcePath() + " by:");
                    this.logRecipesThatMadeChanges(result);
                }
                for (Result result : results.refactoredInPlace) {
                    assert (result.getBefore() != null);
                    this.logger.lifecycle("Changes have been made to " + result.getBefore().getSourcePath() + " by:");
                    this.logRecipesThatMadeChanges(result);
                }
                this.logger.lifecycle("Please review and commit the results.");
                try {
                    Path originalLocation;
                    for (Result result : results.generated) {
                        DefaultProjectParser.writeAfter(results.getProjectRoot(), result);
                    }
                    for (Result result : results.deleted) {
                        assert (result.getBefore() != null);
                        originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath());
                        boolean deleteSucceeded = originalLocation.toFile().delete();
                        if (deleteSucceeded) continue;
                        throw new IOException("Unable to delete file " + originalLocation.toAbsolutePath());
                    }
                    for (Result result : results.moved) {
                        assert (result.getBefore() != null);
                        originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath());
                        File originalParentDir = originalLocation.toFile().getParentFile();
                        if (result.getAfter() instanceof Quark) {
                            Files.move(originalLocation, result.getAfter().getSourcePath(), new CopyOption[0]);
                            continue;
                        }
                        originalLocation.toFile().delete();
                        assert (result.getAfter() != null);
                        Path afterLocation = results.getProjectRoot().resolve(result.getAfter().getSourcePath());
                        File afterParentDir = afterLocation.toFile().getParentFile();
                        if (afterParentDir.exists() && afterParentDir.getAbsolutePath().equalsIgnoreCase(originalParentDir.getAbsolutePath()) && !afterParentDir.getAbsolutePath().equals(originalParentDir.getAbsolutePath())) {
                            if (!originalParentDir.renameTo(afterParentDir)) {
                                throw new RuntimeException("Unable to rename directory from " + originalParentDir.getAbsolutePath() + " To: " + afterParentDir.getAbsolutePath());
                            }
                        } else if (!afterParentDir.exists() && !afterParentDir.mkdirs()) {
                            throw new RuntimeException("Unable to create directory " + afterParentDir.getAbsolutePath());
                        }
                        DefaultProjectParser.writeAfter(results.getProjectRoot(), result);
                    }
                    for (Result result : results.refactoredInPlace) {
                        DefaultProjectParser.writeAfter(results.getProjectRoot(), result);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            finally {
                this.shutdownRewrite();
            }
        }
    }

    private static void writeAfter(Path root, Result result) {
        File targetFile;
        block31: {
            assert (result.getAfter() != null);
            Path targetPath = root.resolve(result.getAfter().getSourcePath());
            targetFile = targetPath.toFile();
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            if (result.getAfter() instanceof Binary) {
                try (FileOutputStream sourceFileWriter = new FileOutputStream(targetFile);){
                    sourceFileWriter.write(((Binary)result.getAfter()).getBytes());
                    break block31;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            if (result.getAfter() instanceof Remote) {
                Remote remote = (Remote)result.getAfter();
                try (FileOutputStream sourceFileWriter = new FileOutputStream(targetFile);){
                    int length;
                    InputStream source = remote.getInputStream((HttpSender)new HttpUrlConnectionSender());
                    byte[] buf = new byte[4096];
                    while ((length = source.read(buf)) > 0) {
                        sourceFileWriter.write(buf, 0, length);
                    }
                    break block31;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            Charset charset = result.getAfter().getCharset() == null ? StandardCharsets.UTF_8 : result.getAfter().getCharset();
            try (BufferedWriter sourceFileWriter = Files.newBufferedWriter(targetPath, charset, new OpenOption[0]);){
                sourceFileWriter.write(new String(result.getAfter().printAll().getBytes(charset), charset));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to rewrite source files", e);
            }
        }
        if (result.getAfter().getFileAttributes() != null) {
            FileAttributes fileAttributes = result.getAfter().getFileAttributes();
            if (targetFile.canRead() != fileAttributes.isReadable()) {
                targetFile.setReadable(fileAttributes.isReadable());
            }
            if (targetFile.canWrite() != fileAttributes.isWritable()) {
                targetFile.setWritable(fileAttributes.isWritable());
            }
            if (targetFile.canExecute() != fileAttributes.isExecutable()) {
                targetFile.setExecutable(fileAttributes.isExecutable());
            }
        }
    }

    protected Environment environment() {
        if (this.environment == null) {
            Environment.Builder env;
            block10: {
                Map<Object, Object> gradleProps = this.project.getProperties().entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                Properties properties = new Properties();
                properties.putAll(gradleProps);
                env = Environment.builder();
                env.scanClassLoader(this.getClass().getClassLoader());
                File rewriteConfig = this.extension.getConfigFile();
                if (rewriteConfig.exists()) {
                    try (FileInputStream is = new FileInputStream(rewriteConfig);){
                        YamlResourceLoader resourceLoader = new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), properties, this.getClass().getClassLoader());
                        env.load((ResourceLoader)resourceLoader);
                        break block10;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to load rewrite configuration", e);
                    }
                }
                if (this.extension.getConfigFileSetDeliberately()) {
                    this.logger.warn("Rewrite configuration file " + rewriteConfig + " does not exist.");
                }
            }
            this.environment = env.build();
        }
        return this.environment;
    }

    public List<SourceFile> parse(ExecutionContext ctx) {
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        HashSet<Path> alreadyParsed = new HashSet<Path>();
        if (this.project == this.project.getRootProject()) {
            for (Project subProject : this.project.getSubprojects()) {
                sourceFiles.addAll(this.parse(subProject, alreadyParsed, ctx));
            }
        }
        sourceFiles.addAll(this.parse(this.project, alreadyParsed, ctx));
        return sourceFiles;
    }

    public List<SourceFile> parse(Project subproject, Set<Path> alreadyParsed, ExecutionContext ctx) {
        try {
            SourceSetContainer sourceSets;
            List<Marker> projectProvenance;
            this.logger.lifecycle("Parsing sources from project {}", new Object[]{subproject.getName()});
            List<NamedStyles> styles = this.getStyles();
            JavaPluginConvention javaConvention = (JavaPluginConvention)subproject.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaConvention == null) {
                projectProvenance = this.sharedProvenance;
                sourceSets = Collections.emptySet();
            } else {
                projectProvenance = new ArrayList<Marker>(this.sharedProvenance);
                projectProvenance.add((Marker)new JavaVersion(Tree.randomId(), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor"), javaConvention.getSourceCompatibility().toString(), javaConvention.getTargetCompatibility().toString()));
                projectProvenance.add((Marker)new JavaProject(Tree.randomId(), subproject.getName(), new JavaProject.Publication(subproject.getGroup().toString(), subproject.getName(), subproject.getVersion().toString())));
                sourceSets = javaConvention.getSourceSets();
            }
            ResourceParser rp = new ResourceParser(this.baseDir, this.project, this.extension);
            Collection exclusions = this.extension.getExclusions().stream().map(pattern -> this.project.getProjectDir().toPath().getFileSystem().getPathMatcher("glob:" + pattern)).collect(Collectors.toList());
            ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
            for (SourceSet sourceSet : sourceSets) {
                Set implementationClasspath;
                List javaPaths = sourceSet.getAllJava().getFiles().stream().filter(it -> it.isFile() && it.getName().endsWith(".java")).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).collect(Collectors.toList());
                Configuration implementation = subproject.getConfigurations().getByName(sourceSet.getImplementationConfigurationName());
                Configuration rewriteImplementation = (Configuration)subproject.getConfigurations().maybeCreate("rewrite" + sourceSet.getImplementationConfigurationName());
                rewriteImplementation.extendsFrom(new Configuration[]{implementation});
                try {
                    implementationClasspath = rewriteImplementation.resolve();
                }
                catch (Exception e) {
                    this.logger.warn("Failed to resolve dependencies from {}:{}. Some type information may be incomplete", (Object)subproject.getPath(), (Object)sourceSet.getImplementationConfigurationName());
                    implementationClasspath = Collections.emptySet();
                }
                List dependencyPaths = Stream.concat(implementationClasspath.stream(), sourceSet.getCompileClasspath().getFiles().stream()).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).distinct().collect(Collectors.toList());
                JavaSourceSet sourceSetProvenance = null;
                if (javaPaths.size() > 0) {
                    this.logger.info("Parsing {} Java sources from {}/{}", new Object[]{javaPaths.size(), this.project.getName(), sourceSet.getName()});
                    JavaParser jp = JavaParser.fromJavaVersion().styles(styles).classpath(dependencyPaths).typeCache(javaTypeCache).logCompilationWarningsAndErrors(this.extension.getLogCompilationWarningsAndErrors()).build();
                    jp.setSourceSet(sourceSet.getName());
                    Instant start = Instant.now();
                    List cus = jp.parse(javaPaths, this.baseDir, ctx);
                    alreadyParsed.addAll(javaPaths);
                    Duration parseDuration = Duration.between(start, Instant.now());
                    this.logger.info("Finished parsing Java sources from {}/{} in {} ({} per source)", new Object[]{this.project.getName(), sourceSet.getName(), TimeUtils.prettyPrint(parseDuration), TimeUtils.prettyPrint(parseDuration.dividedBy(javaPaths.size()))});
                    cus = ListUtils.map((List)cus, cu -> {
                        if (this.isExcluded(exclusions, cu.getSourcePath())) {
                            return null;
                        }
                        return cu;
                    });
                    sourceFiles.addAll(ListUtils.map(this.maybeAutodetectStyles(cus, styles), this.addProvenance(projectProvenance, null)));
                    sourceSetProvenance = jp.getSourceSet(ctx);
                }
                for (File resourcesDir : sourceSet.getResources().getSourceDirectories()) {
                    if (!resourcesDir.exists()) continue;
                    if (sourceSetProvenance == null) {
                        sourceSetProvenance = new JavaSourceSet(Tree.randomId(), sourceSet.getName(), Collections.emptyList());
                    }
                    sourceFiles.addAll(ListUtils.map(rp.parse(resourcesDir.toPath(), alreadyParsed, ctx), this.addProvenance(projectProvenance, (Marker)sourceSetProvenance)));
                }
            }
            if (this.extension.isEnableExperimentalGradleBuildScriptParsing()) {
                File buildScriptFile = subproject.getBuildFile();
                try {
                    if (buildScriptFile.toString().toLowerCase().endsWith(".gradle") && buildScriptFile.exists() && !this.isExcluded(exclusions, buildScriptFile.toPath())) {
                        GradleParser gradleParser = new GradleParser(GroovyParser.builder().styles(styles).typeCache(javaTypeCache).logCompilationWarningsAndErrors(false));
                        sourceFiles.addAll(gradleParser.parse(Collections.singleton(buildScriptFile.toPath()), this.baseDir, ctx));
                        alreadyParsed.add(buildScriptFile.toPath());
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Problem with parsing gradle script at \"" + buildScriptFile.getAbsolutePath() + "\" : ", (Throwable)e);
                }
            }
            sourceFiles.addAll(ListUtils.map(rp.parse(subproject.getProjectDir().toPath(), alreadyParsed, ctx), this.addProvenance(projectProvenance, null)));
            return sourceFiles;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isExcluded(Collection<PathMatcher> exclusions, Path path) {
        for (PathMatcher excluded : exclusions) {
            if (!excluded.matches(path)) continue;
            return true;
        }
        return false;
    }

    private List<NamedStyles> getStyles() {
        if (this.styles == null) {
            this.styles = this.environment().activateStyles(this.getActiveStyles());
            File checkstyleConfig = this.extension.getCheckstyleConfigFile();
            if (checkstyleConfig != null && checkstyleConfig.exists()) {
                try {
                    this.styles.add((NamedStyles)CheckstyleConfigLoader.loadCheckstyleConfig((Path)checkstyleConfig.toPath(), this.extension.getCheckstyleProperties()));
                }
                catch (Exception e) {
                    this.logger.warn("Unable to parse checkstyle configuration", (Throwable)e);
                }
            }
        }
        return this.styles;
    }

    public ResultsContainer listResults(boolean useAstCache, ExecutionContext ctx) {
        List sourceFiles;
        Environment env = this.environment();
        Recipe recipe = env.activateRecipes(this.getActiveRecipes());
        if (recipe.getRecipeList().size() == 0) {
            this.logger.warn("No recipes were activated. Activate a recipe with rewrite.activeRecipe(\"com.fully.qualified.RecipeClassName\") in your build file, or on the command line with -DactiveRecipe=com.fully.qualified.RecipeClassName");
            return new ResultsContainer(this.baseDir, Collections.emptyList());
        }
        this.logger.lifecycle("Validating active recipes");
        Collection validated = recipe.validateAll();
        List<Validated.Invalid> failedValidations = validated.stream().map(Validated::failures).flatMap(Collection::stream).collect(Collectors.toList());
        if (!failedValidations.isEmpty()) {
            failedValidations.forEach(failedValidation -> this.logger.error("Recipe validation error in " + failedValidation.getProperty() + ": " + failedValidation.getMessage(), failedValidation.getException()));
            if (this.extension.getFailOnInvalidActiveRecipes()) {
                throw new RuntimeException("Recipe validation errors detected as part of one or more activeRecipe(s). Please check error logs.");
            }
            this.logger.error("Recipe validation errors detected as part of one or more activeRecipe(s). Execution will continue regardless.");
        }
        if (useAstCache && this.astCache.containsKey(this.project.getProjectDir().toPath().toString())) {
            this.logger.lifecycle("Using cached in-memory ASTs");
            sourceFiles = (List)this.astCache.get(this.project.getProjectDir().toPath().toString());
        } else {
            sourceFiles = this.parse(ctx);
            if (useAstCache) {
                this.astCache.put(this.project.getProjectDir().toPath().toString(), sourceFiles);
            }
        }
        this.logger.lifecycle("All sources parsed, running active recipes: {}", new Object[]{String.join((CharSequence)", ", this.getActiveRecipes())});
        List results = recipe.run(sourceFiles, ctx);
        return new ResultsContainer(this.baseDir, results);
    }

    @Override
    public void clearAstCache() {
        this.astCache.clear();
    }

    @Override
    public void shutdownRewrite() {
        J.clearCaches();
        Git.shutdown();
    }

    private List<J.CompilationUnit> maybeAutodetectStyles(List<J.CompilationUnit> sourceFiles, @Nullable Collection<NamedStyles> styles) {
        if (styles != null) {
            return sourceFiles;
        }
        Autodetect autodetect = Autodetect.detect(sourceFiles);
        List<Autodetect> namedStyles = Collections.singletonList(autodetect);
        ImportLayoutStyle importLayout = (ImportLayoutStyle)NamedStyles.merge(ImportLayoutStyle.class, namedStyles);
        this.logger.debug("Auto-detected import layout:\n{}", (Object)importLayout);
        SpacesStyle spacesStyle = (SpacesStyle)NamedStyles.merge(SpacesStyle.class, namedStyles);
        this.logger.debug("Auto-detected spaces style:\n{}", (Object)spacesStyle);
        TabsAndIndentsStyle tabsStyle = (TabsAndIndentsStyle)NamedStyles.merge(TabsAndIndentsStyle.class, namedStyles);
        this.logger.debug("Auto-detected tabs and indents:\n{}", (Object)tabsStyle);
        return ListUtils.map(sourceFiles, cu -> {
            List markers = ListUtils.concat((List)ListUtils.map((List)cu.getMarkers().getMarkers(), m -> m instanceof NamedStyles ? null : m), (Object)autodetect);
            return cu.withMarkers(cu.getMarkers().withMarkers(markers));
        });
    }

    private <T extends SourceFile> UnaryOperator<T> addProvenance(List<Marker> projectProvenance, @Nullable Marker sourceSet) {
        return s -> {
            Markers m = s.getMarkers();
            for (Marker marker : projectProvenance) {
                m = m.add(marker);
            }
            if (sourceSet != null) {
                m = m.add(sourceSet);
            }
            return s.withMarkers(m);
        };
    }

    protected void logRecipesThatMadeChanges(Result result) {
        String indent = "    ";
        String prefix = "    ";
        for (RecipeDescriptor recipeDescriptor : result.getRecipeDescriptorsThatMadeChanges()) {
            this.logRecipe(recipeDescriptor, prefix);
            prefix = prefix + indent;
        }
    }

    private void logRecipe(RecipeDescriptor rd, String prefix) {
        String opts;
        StringBuilder recipeString = new StringBuilder(prefix + rd.getName());
        if (!rd.getOptions().isEmpty() && !(opts = rd.getOptions().stream().map(option -> {
            if (option.getValue() != null) {
                return option.getName() + "=" + option.getValue();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(", "))).isEmpty()) {
            recipeString.append(": {").append(opts).append("}");
        }
        this.logger.warn(recipeString.toString());
        for (RecipeDescriptor rchild : rd.getRecipeList()) {
            this.logRecipe(rchild, prefix + "    ");
        }
    }
}

