/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.security.YamlHelper;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ArtifactSecurityRecipe
extends Recipe {
    private static final Set<String> DANGEROUS_PATHS = new HashSet<String>(Arrays.asList("~/.ssh/", "~/.ssh", ".ssh/", ".ssh", "~/.aws/", "~/.aws", ".aws/", ".aws", "~/.docker/", "~/.docker", ".docker/", ".docker", "~/.kube/", "~/.kube", ".kube/", ".kube", "~/.config/", "~/.config", "~/.gitconfig", ".gitconfig", "~/.npmrc", ".npmrc", "~/.pypirc", ".pypirc", "/etc/passwd", "/etc/shadow", "/etc/hosts", "/var/log/", "/var/log", "/tmp/", "/tmp", "/root/", "/root", "~/.bash_history", ".bash_history", "~/.zsh_history", ".zsh_history", "/home/", "/home"));
    private static final String[] DANGEROUS_PATTERNS = new String[]{"config.json", "credentials", "token", "secret", "key", "password", "passwd"};

    public String getDisplayName() {
        return "Find credential persistence through GitHub Actions artifacts";
    }

    public String getDescription() {
        return "Find workflows that may persist credentials through artifact uploads. This occurs when checkout actions don't disable credential persistence and upload actions include sensitive paths that may contain credentials, SSH keys, or configuration files. Based on [zizmor's `artipacked` audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/artipacked.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new ArtifactSecurityVisitor());
    }

    @Generated
    public ArtifactSecurityRecipe() {
    }

    @Generated
    public String toString() {
        return "ArtifactSecurityRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactSecurityRecipe)) {
            return false;
        }
        ArtifactSecurityRecipe other = (ArtifactSecurityRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArtifactSecurityRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class ArtifactSecurityVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private static final JsonPathMatcher STEP_USES_MATCHER = new JsonPathMatcher("$..steps[*].uses");

        private ArtifactSecurityVisitor() {
        }

        public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
            Yaml.Document d = super.visitDocument(document, (Object)ctx);
            if (d.getBlock() instanceof Yaml.Mapping) {
                this.checkWorkflowForCredentialPersistence((Yaml.Mapping)d.getBlock());
            }
            return d;
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (STEP_USES_MATCHER.matches(this.getCursor())) {
                return this.checkUsesEntry(mappingEntry);
            }
            return mappingEntry;
        }

        private Yaml.Mapping.Entry checkUsesEntry(Yaml.Mapping.Entry entry) {
            String usesValue = YamlHelper.getScalarValue(entry.getValue());
            if (usesValue == null) {
                return entry;
            }
            if (usesValue.startsWith("actions/checkout")) {
                return this.checkCheckoutAction(entry);
            }
            if (usesValue.startsWith("actions/upload-artifact")) {
                return this.checkUploadArtifactAction(entry);
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkCheckoutAction(Yaml.Mapping.Entry entry) {
            Yaml.Mapping stepMapping = this.findParentStepMapping();
            if (stepMapping == null) {
                return entry;
            }
            String persistCredentials = YamlHelper.findNestedScalarValue(stepMapping, "with", "persist-credentials");
            if (persistCredentials == null) {
                if (this.workflowHasArtifactUpload()) {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Checkout step does not disable credential persistence, which may expose credentials in artifacts.");
                }
            } else if ("true".equals(persistCredentials) && this.workflowHasArtifactUpload()) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Checkout step explicitly enables credential persistence, which may expose credentials in artifacts.");
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkUploadArtifactAction(Yaml.Mapping.Entry entry) {
            Yaml.Mapping stepMapping = this.findParentStepMapping();
            if (stepMapping == null) {
                return entry;
            }
            String pathValue = YamlHelper.findNestedScalarValue(stepMapping, "with", "path");
            if (pathValue != null && this.hasDangerousArtifactPaths(pathValue)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Uploading potentially sensitive paths that may contain credentials or configuration files.");
            }
            return entry;
        }

        private void checkWorkflowForCredentialPersistence(Yaml.Mapping workflowMapping) {
            new YamlIsoVisitor<Void>(){

                public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, Void ctx) {
                    String usesValue;
                    if (!"uses".equals(entry.getKey().getValue()) || !(entry.getValue() instanceof Yaml.Scalar) || (usesValue = ((Yaml.Scalar)entry.getValue()).getValue()).startsWith("actions/checkout") || usesValue.startsWith("actions/upload-artifact")) {
                        // empty if block
                    }
                    return super.visitMappingEntry(entry, (Object)ctx);
                }
            }.visit((Tree)workflowMapping, null);
        }

        private boolean workflowHasArtifactUpload() {
            for (Cursor current = this.getCursor(); current != null; current = current.getParent()) {
                Object value = current.getValue();
                if (!(value instanceof Yaml.Document)) continue;
                Yaml.Document doc = (Yaml.Document)value;
                return this.containsUploadArtifact(doc);
            }
            return false;
        }

        private boolean containsUploadArtifact(Yaml.Document document) {
            final AtomicBoolean found = new AtomicBoolean(false);
            new YamlIsoVisitor<Void>(){

                public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, Void ctx) {
                    String usesValue;
                    if ("uses".equals(entry.getKey().getValue()) && entry.getValue() instanceof Yaml.Scalar && (usesValue = ((Yaml.Scalar)entry.getValue()).getValue()).startsWith("actions/upload-artifact")) {
                        found.set(true);
                    }
                    return super.visitMappingEntry(entry, (Object)ctx);
                }
            }.visit((Tree)document, null);
            return found.get();
        }

        private boolean hasDangerousArtifactPaths(String pathValue) {
            for (String dangerousPath : DANGEROUS_PATHS) {
                if (!pathValue.contains(dangerousPath)) continue;
                return true;
            }
            String lowerPath = pathValue.toLowerCase();
            for (String pattern : DANGEROUS_PATTERNS) {
                if (!lowerPath.contains(pattern)) continue;
                return true;
            }
            return ".".equals(pathValue.trim()) || "~".equals(pathValue.trim()) || "/".equals(pathValue.trim());
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Yaml.Mapping findParentStepMapping() {
            for (Cursor current = this.getCursor(); current != null; current = current.getParent()) {
                Yaml.Mapping mapping;
                boolean hasUses;
                Object value = current.getValue();
                if (!(value instanceof Yaml.Mapping) || !(hasUses = (mapping = (Yaml.Mapping)value).getEntries().stream().anyMatch(entry -> "uses".equals(entry.getKey().getValue())))) continue;
                return mapping;
            }
            return null;
        }
    }
}

