/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.migrate.guava.PreferJavaStringJoin;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

class PreferJavaStringJoinVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private static final MethodMatcher ON_METHOD_MATCHER = new MethodMatcher("com.google.common.base.Joiner on(String)");

    PreferJavaStringJoinVisitor() {
    }

    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
        J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
        if (!(PreferJavaStringJoin.JOIN_METHOD_MATCHER.matches((MethodCall)mi) && mi.getSelect() instanceof J.MethodInvocation && ON_METHOD_MATCHER.matches(mi.getSelect()))) {
            return mi;
        }
        boolean rewriteToJavaString = false;
        List arguments = mi.getArguments();
        if (arguments.size() == 1) {
            JavaType javaType = ((Expression)arguments.get(0)).getType();
            rewriteToJavaString = this.isCompatibleArray(javaType) || this.isCompatibleIterable(javaType);
        } else if (arguments.size() >= 2) {
            rewriteToJavaString = this.isCompatibleArguments(arguments);
        }
        if (rewriteToJavaString) {
            J.MethodInvocation select = (J.MethodInvocation)mi.getSelect();
            assert (select != null);
            List<Expression> newArgs = this.appendArguments(select.getArguments(), mi.getArguments());
            this.maybeRemoveImport("com.google.common.base.Joiner");
            return ((J.MethodInvocation)JavaTemplate.apply((String)"String.join(#{any(java.lang.CharSequence)}", (Cursor)this.getCursor(), (JavaCoordinates)mi.getCoordinates().replace(), (Object[])new Object[]{select.getArguments().get(0)})).withArguments(newArgs);
        }
        return mi;
    }

    private boolean isCompatibleArguments(List<Expression> arguments) {
        return arguments.stream().map(Expression::getType).allMatch(PreferJavaStringJoinVisitor::isCharSequence);
    }

    private boolean isCompatibleArray(@Nullable JavaType javaType) {
        if (javaType instanceof JavaType.Array) {
            return PreferJavaStringJoinVisitor.isCharSequence(((JavaType.Array)javaType).getElemType());
        }
        return false;
    }

    private boolean isCompatibleIterable(@Nullable JavaType javaType) {
        if (TypeUtils.isAssignableTo((String)Iterable.class.getName(), (JavaType)javaType) && javaType instanceof JavaType.Parameterized) {
            List typeParameters = ((JavaType.Parameterized)javaType).getTypeParameters();
            return typeParameters.size() == 1 && PreferJavaStringJoinVisitor.isCharSequence((JavaType)typeParameters.get(0));
        }
        return false;
    }

    private static boolean isCharSequence(@Nullable JavaType javaType) {
        return TypeUtils.isString((JavaType)javaType) || TypeUtils.isAssignableTo((String)CharSequence.class.getName(), (JavaType)javaType);
    }

    private List<Expression> appendArguments(List<Expression> firstArgs, List<Expression> secondArgs) {
        ArrayList<Expression> args = new ArrayList<Expression>(firstArgs);
        if (!secondArgs.isEmpty()) {
            Expression e = secondArgs.remove(0);
            args.add((Expression)e.withPrefix(e.getPrefix().withWhitespace(" ")));
            args.addAll(secondArgs);
        }
        return args;
    }
}

