/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazySet;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.MediaTypeSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.impl.AbstractDynamicMetadataResolver;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;
import org.slf4j.MDC;

public abstract class AbstractDynamicHTTPMetadataResolver
extends AbstractDynamicMetadataResolver {
    @Nonnull
    @NotEmpty
    public static final String[] DEFAULT_CONTENT_TYPES = new String[]{"application/samlmetadata+xml", "application/xml", "text/xml"};
    @Nonnull
    @NotEmpty
    public static final String MDC_ATTRIB_CURRENT_REQUEST_URI = AbstractDynamicHTTPMetadataResolver.class.getName() + ".currentRequestURI";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicHTTPMetadataResolver.class);
    @NonnullAfterInit
    private HttpClient httpClient;
    @NonnullAfterInit
    private List<String> supportedContentTypes;
    @NonnullAfterInit
    private String supportedContentTypesValue;
    @NonnullAfterInit
    private Set<MediaType> supportedMediaTypes;
    @Nonnull
    private HttpClientResponseHandler<XMLObject> responseHandler;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    public AbstractDynamicHTTPMetadataResolver(@Nonnull HttpClient client) {
        this(null, client);
    }

    public AbstractDynamicHTTPMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull HttpClient client) {
        super(backgroundTaskTimer);
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient may not be null");
        this.responseHandler = new BasicMetadataResponseHandler();
    }

    @Nullable
    protected HttpClientSecurityParameters getHttpClientSecurityParameters() {
        return this.httpClientSecurityParameters;
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    @NonnullAfterInit
    @NotLive
    @Unmodifiable
    protected Set<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    @NonnullAfterInit
    @NotLive
    @Unmodifiable
    public List<String> getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    public void setSupportedContentTypes(@Nullable List<String> types) {
        this.checkSetterPreconditions();
        this.supportedContentTypes = types == null ? CollectionSupport.emptyList() : StringSupport.normalizeStringCollection(types).stream().filter(s -> s != null).map(String::toLowerCase).collect(Collectors.toUnmodifiableList());
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        if (this.getSupportedContentTypes() == null) {
            this.setSupportedContentTypes(Arrays.asList(DEFAULT_CONTENT_TYPES));
        }
        if (!this.getSupportedContentTypes().isEmpty()) {
            this.supportedContentTypesValue = StringSupport.listToStringValue(this.getSupportedContentTypes(), (String)", ");
            this.supportedMediaTypes = new LazySet();
            for (String contentType : this.getSupportedContentTypes()) {
                this.supportedMediaTypes.add(MediaType.parse((String)contentType));
            }
        } else {
            this.supportedMediaTypes = CollectionSupport.emptySet();
        }
        this.log.debug("{} Supported content types are: {}", (Object)this.getLogPrefix(), this.getSupportedContentTypes());
    }

    @Override
    protected void doDestroy() {
        this.httpClient = null;
        this.httpClientSecurityParameters = null;
        this.supportedContentTypes = null;
        this.supportedContentTypesValue = null;
        this.supportedMediaTypes = null;
        super.doDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected XMLObject fetchFromOriginSource(@Nullable CriteriaSet criteria) throws IOException {
        ClassicHttpRequest request = this.buildHttpRequest(criteria);
        if (request == null) {
            this.log.debug("{} Could not build request based on input criteria, unable to query", (Object)this.getLogPrefix());
            return null;
        }
        HttpClientContext context = this.buildHttpClientContext(request);
        try {
            MDC.put((String)MDC_ATTRIB_CURRENT_REQUEST_URI, (String)request.getRequestUri());
            XMLObject result = (XMLObject)this.httpClient.execute(request, (HttpContext)context, this.responseHandler);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)context, (String)request.getScheme());
            XMLObject xMLObject = result;
            return xMLObject;
        }
        finally {
            MDC.remove((String)MDC_ATTRIB_CURRENT_REQUEST_URI);
        }
    }

    @Nullable
    protected ClassicHttpRequest buildHttpRequest(@Nullable CriteriaSet criteria) {
        String url = this.buildRequestURL(criteria);
        this.log.debug("{} Built request URL of: {}", (Object)this.getLogPrefix(), (Object)url);
        if (url == null) {
            this.log.debug("{} Could not construct request URL from input criteria, unable to query", (Object)this.getLogPrefix());
            return null;
        }
        HttpGet getMethod = new HttpGet(url);
        if (!Strings.isNullOrEmpty((String)this.supportedContentTypesValue)) {
            getMethod.addHeader("Accept", (Object)this.supportedContentTypesValue);
        }
        return getMethod;
    }

    @Nullable
    protected abstract String buildRequestURL(@Nullable CriteriaSet var1);

    @Nonnull
    protected HttpClientContext buildHttpClientContext(@Nonnull ClassicHttpRequest request) {
        HttpClientContext context = HttpClientSecuritySupport.buildHttpClientContext((HttpClientSecurityParameters)this.httpClientSecurityParameters);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)context, (HttpRequest)request);
        return context;
    }

    public class BasicMetadataResponseHandler
    implements HttpClientResponseHandler<XMLObject> {
        /*
         * Exception decompiling
         */
        public XMLObject handleResponse(ClassicHttpResponse response) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void validateHttpResponse(@Nonnull ClassicHttpResponse response) throws ResolverException {
            if (!AbstractDynamicHTTPMetadataResolver.this.getSupportedMediaTypes().isEmpty()) {
                String contentType = StringSupport.trimOrNull((String)response.getEntity().getContentType());
                AbstractDynamicHTTPMetadataResolver.this.log.debug("{} Saw raw Content-Type from response header '{}'", (Object)AbstractDynamicHTTPMetadataResolver.this.getLogPrefix(), (Object)contentType);
                if (!MediaTypeSupport.validateContentType((String)contentType, AbstractDynamicHTTPMetadataResolver.this.getSupportedMediaTypes(), (boolean)true, (boolean)false)) {
                    throw new ResolverException("HTTP response specified an unsupported Content-Type MIME type: " + contentType);
                }
            }
        }
    }
}

