/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wsaddressing.messaging.impl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.wsaddressing.Action;
import org.opensaml.soap.wsaddressing.WSAddressingConstants;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.slf4j.Logger;

public class ValidateActionHandler
extends AbstractMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateActionHandler.class);
    @Nullable
    private String expectedActionURI;

    @Nullable
    public String getExpectedActionURI() {
        return this.expectedActionURI;
    }

    public void setExpectedActionURI(@Nullable String uri) {
        this.checkSetterPreconditions();
        this.expectedActionURI = StringSupport.trimOrNull((String)uri);
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        WSAddressingContext addressing = (WSAddressingContext)messageContext.getSubcontext(WSAddressingContext.class);
        if (addressing != null && addressing.getActionURI() != null) {
            this.expectedActionURI = addressing.getActionURI();
        }
        if (this.expectedActionURI == null) {
            this.log.debug("No expected WS-Addressing Action URI found locally or in message context, skipping evaluation");
            return false;
        }
        return true;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        Action header = this.getAction(messageContext);
        String headerValue = header != null ? StringSupport.trimOrNull((String)header.getURI()) : null;
        this.log.debug("Checking inbound message WS-Addressing Action URI value: {}", (Object)headerValue);
        if (header == null || !Objects.equals(this.getExpectedActionURI(), headerValue)) {
            this.log.warn("Inbound WS-Addressing Action URI '{}' did not match the expected value '{}'", (Object)headerValue, (Object)this.getExpectedActionURI());
            SOAPMessagingSupport.registerSOAP11Fault((MessageContext)messageContext, (QName)WSAddressingConstants.SOAP_FAULT_ACTION_NOT_SUPPORTED, (String)("Action URI not supported: " + headerValue), null, null, null);
            throw new MessageHandlerException("Inbound WS-Addressing Action URI did not match the expected value");
        }
        this.log.debug("Inbound WS-Addressing Action URI matched expected value");
        SOAPMessagingSupport.registerUnderstoodHeader((MessageContext)messageContext, (XMLObject)header);
    }

    @Nullable
    protected Action getAction(@Nonnull MessageContext messageContext) {
        List actions = SOAPMessagingSupport.getInboundHeaderBlock((MessageContext)messageContext, (QName)Action.ELEMENT_NAME);
        if (actions != null && !actions.isEmpty()) {
            return (Action)actions.get(0);
        }
        return null;
    }
}

