/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.soap.wssecurity.AttributedDateTime;
import org.opensaml.soap.wssecurity.IdBearing;
import org.opensaml.soap.wssecurity.impl.AbstractWSSecurityObject;

public class AttributedDateTimeImpl
extends AbstractWSSecurityObject
implements AttributedDateTime {
    @Nullable
    private Instant dateTimeValue;
    @Nullable
    private String stringValue;
    @Nullable
    private String id;
    @Nonnull
    private final AttributeMap unknownAttributes = new AttributeMap((XMLObject)this);

    public AttributedDateTimeImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Nullable
    public Instant getDateTime() {
        return this.dateTimeValue;
    }

    public void setDateTime(@Nullable Instant newDateTime) {
        this.dateTimeValue = newDateTime;
        this.stringValue = this.prepareForAssignment(this.stringValue, this.dateTimeValue != null ? DOMTypeSupport.instantToString((Instant)this.dateTimeValue) : null);
    }

    @Nullable
    public String getValue() {
        return this.stringValue;
    }

    public void setValue(@Nullable String newValue) {
        this.dateTimeValue = newValue != null ? DOMTypeSupport.stringToInstant((String)newValue) : null;
        this.stringValue = this.prepareForAssignment(this.stringValue, newValue);
    }

    @Nullable
    public String getWSUId() {
        return this.id;
    }

    public void setWSUId(@Nullable String newId) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newId);
        this.registerOwnID(oldID, this.id);
        this.manageQualifiedAttributeNamespace(IdBearing.WSU_ID_ATTR_NAME, this.id != null);
    }

    @Nonnull
    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }
}

