/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.bootstrap;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgl.bootstrap.PropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Version
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(Version.class);
    public static final String UNKNOWN_STR = "unknown";
    public static final Version UNKNOWN = new Version("", "unknown", "unknown", null);
    private static final ConcurrentMap<String, Version> cache = new ConcurrentHashMap<String, Version>();
    private final String artifactId;
    private final String packageName;
    private final String projectVersion;
    private final String buildNumber;
    private final String versionTag;

    public Version(String packageName, String artifactId, String projectVersion, String buildNumber) {
        this.packageName = packageName;
        this.artifactId = artifactId.trim();
        this.projectVersion = projectVersion.trim();
        this.buildNumber = Version.isBlank(buildNumber) ? "" : buildNumber.trim();
        this.versionTag = this.generateVersionTag(this.projectVersion, this.buildNumber);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public String getVersion() {
        return this.versionTag;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public boolean isUnknown() {
        return UNKNOWN.equals(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Version) {
            Version that = (Version)o;
            return that.versionTag.equals(this.versionTag) && that.packageName.equals(this.packageName) && that.artifactId.equals(this.artifactId);
        }
        return false;
    }

    public int hashCode() {
        int result = this.artifactId.hashCode();
        result = 31 * result + this.packageName.hashCode();
        result = 31 * result + this.versionTag.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.artifactId).append("-").append(this.getVersion());
        return sb.toString();
    }

    public static Version get() {
        StackTraceElement[] sa = new RuntimeException().getStackTrace();
        StackTraceElement ste = sa[1];
        String className = ste.getClassName();
        return Version.ofPackage(className);
    }

    public static Version ofPackage(String packageName) {
        if (!Version.isValidPackageName(packageName)) {
            throw new IllegalArgumentException("package name is not valid: " + packageName);
        }
        return Version.of_(packageName);
    }

    public static Version of(Class<?> clazz) {
        String className = clazz.getName();
        int pos = className.lastIndexOf(46);
        if (pos < 0) {
            return UNKNOWN;
        }
        String packageName = className.substring(0, pos);
        return Version.of_(packageName);
    }

    public static Version of(Package pkg) {
        return Version.of_(pkg.getName());
    }

    private static Version of_(String packageName) {
        Version version = (Version)cache.get(packageName);
        if (null != version) {
            return version;
        }
        version = Version.loadFromResource(packageName);
        if (null == version) {
            int pos = packageName.lastIndexOf(46);
            if (pos < 0) {
                return UNKNOWN;
            }
            return Version.ofPackage(packageName.substring(0, pos));
        }
        cache.put(packageName, version);
        return version;
    }

    private static boolean isBlank(String s) {
        return null == s || "".equals(s.trim());
    }

    private static Version loadFromResource(String packageName) {
        Properties properties = PropertyLoader.INSTANCE.loadFromResource(packageName);
        return null == properties ? null : Version.loadFrom(properties, packageName);
    }

    private static Version loadFrom(Properties properties, String packageName) {
        String projectVersion;
        String artifactId = properties.getProperty("artifact");
        if (Version.isBlank(artifactId)) {
            logger.warn("artifact not defined in .version file: %s", (Object)packageName);
            artifactId = packageName;
        }
        if (Version.isBlank(projectVersion = properties.getProperty("version"))) {
            logger.error("version not defined in .version file: %s", (Object)packageName);
            return UNKNOWN;
        }
        String buildNumber = properties.getProperty("build");
        return new Version(packageName, Version.checkVariableRef(artifactId, packageName), Version.checkVariableRef(projectVersion, packageName), Version.checkVariableRef(buildNumber, packageName));
    }

    private static boolean isValidPackageName(String s) {
        if (null == s) {
            return false;
        }
        int len = s.length();
        if (0 == len) {
            return false;
        }
        char[] ca = s.toCharArray();
        if (!Character.isJavaIdentifierStart(ca[0])) {
            return false;
        }
        boolean lastTimeIsDot = false;
        for (int i = 1; i < len; ++i) {
            char c = ca[i];
            if ('.' == c) {
                if (lastTimeIsDot) {
                    return false;
                }
                lastTimeIsDot = true;
                continue;
            }
            lastTimeIsDot = false;
            if (Character.isJavaIdentifierPart(ca[i])) continue;
            return false;
        }
        return true;
    }

    private String generateVersionTag(String projectVersion, String buildNumber) {
        StringBuilder sb = new StringBuilder(Version.decoratedProjectVersion(projectVersion));
        if (!Version.isBlank(buildNumber)) {
            sb.append("-").append(buildNumber);
        }
        return sb.toString();
    }

    static String decoratedProjectVersion(String projectVersion) {
        if (UNKNOWN_STR.equals(projectVersion)) {
            return projectVersion;
        }
        return (projectVersion.endsWith("-SNAPSHOT") ? "v" : "r") + projectVersion;
    }

    static void clearCache() {
        cache.clear();
    }

    private static String checkVariableRef(String s, String pkg) {
        if (null == s) {
            return null;
        }
        if (s.contains("${")) {
            logger.warn("variable found in .version file for %s. please make sure your resource has been filtered", (Object)pkg);
        }
        return s;
    }
}

