/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.http.servlet.ServletCookie;
import org.osgl.util.C;
import org.osgl.util.E;

public class ServletRequest
extends H.Request {
    private H.Method methodOverride;
    private HttpServletRequest r;
    private C.Map<String, H.Cookie> cookies;

    protected Class _impl() {
        return ServletRequest.class;
    }

    public ServletRequest(HttpServletRequest req) {
        E.NPE((Object)req);
        this.r = req;
    }

    @Override
    public Iterable<String> headers(String name) {
        return C.enumerable((Enumeration)this.r.getHeaders(name));
    }

    @Override
    public String path() {
        String s1 = this.r.getServletPath();
        String s2 = this.r.getPathInfo();
        if (null == s1) {
            return s2;
        }
        if (null == s2) {
            return s1;
        }
        return s1 + s2;
    }

    @Override
    public String contextPath() {
        return this.r.getContextPath();
    }

    @Override
    public String query() {
        return this.r.getQueryString();
    }

    @Override
    public boolean secure() {
        return this.r.isSecure();
    }

    @Override
    protected String _ip() {
        return this.r.getRemoteAddr();
    }

    @Override
    protected void _initCookieMap() {
        Cookie[] ca;
        for (Cookie c : ca = this.r.getCookies()) {
            this._setCookie(c.getName(), ServletCookie.of(c));
        }
    }

    @Override
    public String header(String name) {
        return this.r.getHeader(name);
    }

    @Override
    public H.Method method() {
        return null == this.methodOverride ? H.Method.valueOfIgnoreCase(this.r.getMethod()) : this.methodOverride;
    }

    public ServletRequest method(H.Method method) {
        this.methodOverride = (H.Method)((Object)$.NPE((Object)((Object)method)));
        return this;
    }

    @Override
    public InputStream createInputStream() throws IllegalStateException {
        try {
            return this.r.getInputStream();
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    @Override
    public String paramVal(String name) {
        return this.r.getParameter(name);
    }

    @Override
    public String[] paramVals(String name) {
        String[] ret = this.r.getParameterValues(name);
        if (null == ret) {
            ret = new String[]{};
        }
        return ret;
    }

    @Override
    public Iterable<String> paramNames() {
        return C.enumerable((Enumeration)this.r.getParameterNames());
    }
}

