/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.mvc.result;

import java.io.Flushable;
import java.io.Writer;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.OsglConfig;
import org.osgl.http.H;
import org.osgl.mvc.MvcConfig;
import org.osgl.mvc.result.Result;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public abstract class RenderContent
extends Result {
    private String content;
    private Lang.Visitor<Writer> contentWriter;
    private Lang.Func0<String> stringContentProducer;
    private H.Format format;
    private boolean outputEncoding;

    protected RenderContent(H.Format format) {
        this("", format, true);
    }

    protected RenderContent(String content, H.Format format) {
        this(content, format, true);
    }

    protected RenderContent(Lang.Visitor<Writer> contentWriter, H.Format format) {
        this(contentWriter, format, true);
    }

    protected RenderContent(H.Status status, String content, H.Format format) {
        this(status, content, format, true);
    }

    protected RenderContent(H.Status status, Lang.Visitor<Writer> contentWriter, H.Format format) {
        this(status, contentWriter, format, true);
    }

    protected RenderContent(H.Status status, Lang.Func0<String> contentProducer, H.Format format) {
        this(status, contentProducer, format, true);
    }

    protected RenderContent(String content, H.Format format, boolean outputEncoding) {
        this(H.Status.OK, content, format, outputEncoding);
    }

    protected RenderContent(Lang.Visitor<Writer> contentWriter, H.Format format, boolean outputEncoding) {
        this(H.Status.OK, contentWriter, format, outputEncoding);
    }

    protected RenderContent(H.Status status, String content, H.Format format, boolean outputEncoding) {
        super(status);
        E.NPE((Object)format);
        this.content = content;
        this.format = format;
        this.outputEncoding = outputEncoding;
    }

    protected RenderContent(H.Status status, Lang.Visitor<Writer> contentWriter, H.Format format, boolean outputEncoding) {
        super(status);
        E.NPE((Object)format);
        this.contentWriter = (Lang.Visitor)$.requireNotNull(contentWriter);
        this.format = format;
        this.outputEncoding = outputEncoding;
    }

    protected RenderContent(H.Status status, Lang.Func0<String> producer, H.Format format, boolean outputEncoding) {
        super(status);
        E.NPE((Object)format);
        this.stringContentProducer = (Lang.Func0)$.requireNotNull(producer);
        this.format = format;
        this.outputEncoding = outputEncoding;
    }

    protected void setContentType(H.Response resp) {
        String encoding;
        String s = this.format().contentType();
        if (this.isOutputEncoding() && S.notBlank((String)(encoding = resp.characterEncoding()))) {
            s = S.builder((String)s).append("; charset=").append(encoding).toString();
        }
        resp.initContentType(s);
    }

    public boolean isOutputEncoding() {
        return this.outputEncoding;
    }

    public RenderContent setOutputEncoding(boolean outputEncoding) {
        this.outputEncoding = outputEncoding;
        return this;
    }

    public H.Format format() {
        return this.format;
    }

    public String content() {
        if (null == this.content) {
            this.content = (String)this.stringContentProducer.apply();
        }
        return this.content;
    }

    public Lang.Visitor<Writer> contentWriter() {
        return this.contentWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(H.Request req, H.Response resp) {
        this.applyBeforeCommitHandler(req, resp);
        try {
            this.applyStatus(resp);
            this.setContentType(resp);
            this.applyCookies(resp);
            this.applyHeaders(resp);
            Lang.Visitor<Writer> contentWriter = this.contentWriter();
            if (null != contentWriter) {
                Writer writer = resp.writer();
                contentWriter.visit((Object)writer);
                IO.flush((Flushable)writer);
            } else {
                String content = this.content();
                if (content.length() > OsglConfig.getThreadLocalCharBufferLimit()) {
                    MvcConfig.triggerAlarm("ALARM_BIG_CONTENT_ENCOUNTERED");
                }
                resp.writeContent(content);
            }
        }
        finally {
            try {
                resp.commit();
                this.applyAfterCommitHandler(req, resp);
            }
            finally {
                RenderContent.clearThreadLocals();
            }
        }
    }
}

