/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.mvc.result;

import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.FastRuntimeException;
import org.osgl.http.H;
import org.osgl.mvc.MvcConfig;
import org.osgl.util.C;
import org.osgl.util.KVStore;
import org.osgl.util.S;

public class Result
extends FastRuntimeException {
    private static final ThreadLocal<Payload> payload = new ThreadLocal<Payload>(){

        @Override
        protected Payload initialValue() {
            return new Payload();
        }
    };
    private H.Status status;
    private long timestamp = $.ms();
    private Map<String, H.Header> headers = new HashMap<String, H.Header>();
    private Map<String, H.Cookie> cookies = new HashMap<String, H.Cookie>();

    protected static Payload payload() {
        return payload.get();
    }

    protected static Payload touchPayload() {
        return Result.payload().touch();
    }

    protected Result() {
        this.status = H.Status.OK;
    }

    protected Result(H.Status status) {
        this.status = status;
    }

    protected Result(H.Status status, String message) {
        super(message);
        this.status = status;
    }

    protected Result(H.Status status, String message, Object ... args) {
        super(message, args);
        this.status = status;
    }

    protected Result(H.Status status, Throwable cause) {
        super(cause);
        this.status = status;
    }

    protected Result(H.Status status, Throwable cause, String message, Object ... args) {
        super(cause, message, args);
        this.status = status;
    }

    public H.Status status() {
        return this.status;
    }

    public int statusCode() {
        return this.status().code();
    }

    public Result status(H.Status status) {
        this.status = status;
        return this;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Result header(H.Header header) {
        this.headers.put(header.name(), header);
        return this;
    }

    public Result addHeader(String name, String ... values) {
        H.Header header = this.headers.get(name);
        header = null == header ? new H.Header(name, values) : new H.Header(name, (Iterable)C.list((List)header.values()).append(C.listOf((Object[])values)));
        this.headers.put(name, header);
        return this;
    }

    public Result addCookie(H.Cookie cookie) {
        this.cookies.put(cookie.name(), cookie);
        return this;
    }

    protected final void applyHeaders(H.Response response) {
        if (this.headers.isEmpty()) {
            return;
        }
        for (H.Header header : this.headers.values()) {
            String name = header.name();
            for (String value : header.values()) {
                response.addHeader(name, value);
            }
        }
    }

    protected final void applyCookies(H.Response response) {
        if (this.cookies.isEmpty()) {
            return;
        }
        for (H.Cookie cookie : this.cookies.values()) {
            response.addCookie(cookie);
        }
    }

    protected final void applyStatus(H.Response response) {
        response.status(this.statusCode());
    }

    protected final void applyBeforeCommitHandler(H.Request req, H.Response resp) {
        MvcConfig.applyBeforeCommitResultHandler(this, req, resp);
    }

    protected final void applyAfterCommitHandler(H.Request req, H.Response resp) {
        MvcConfig.applyAfterCommitResultHandler(this, req, resp);
    }

    protected void applyMessage(H.Request request, H.Response response) {
        String msg = this.getMessage();
        if (S.notBlank((String)msg)) {
            response.writeContent(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(H.Request req, H.Response resp) {
        this.applyBeforeCommitHandler(req, resp);
        try {
            this.applyStatus(resp);
            this.applyCookies(resp);
            this.applyHeaders(resp);
            this.applyMessage(req, resp);
        }
        finally {
            try {
                resp.commit();
                this.applyAfterCommitHandler(req, resp);
            }
            finally {
                Result.clearThreadLocals();
            }
        }
    }

    public static void clearThreadLocals() {
        payload.remove();
    }

    protected static class Payload
    extends KVStore {
        public String message;
        public Lang.Visitor<Writer> contentWriter;
        public Lang.Func0<String> stringContentProducer;
        public Integer errorCode;
        public Throwable cause;
        public H.Format format;
        public H.Status status;
        public Object attachment;
        public String etag;
        public Boolean outputEncoding;
        public long timestamp;

        protected Payload() {
        }

        public Payload message(String message) {
            this.message = message;
            return this;
        }

        public Payload message(String message, Object ... args) {
            this.message = S.fmt((String)message, (Object[])args);
            return this;
        }

        public Payload contentWriter(Lang.Visitor<Writer> contentWriter) {
            this.contentWriter = contentWriter;
            return this;
        }

        public Payload stringContentProducer(Lang.Func0<String> producer) {
            this.stringContentProducer = producer;
            return this;
        }

        public Payload touch() {
            this.timestamp = $.ms();
            this.outputEncoding(MvcConfig.renderJsonOutputCharset());
            return this;
        }

        public Payload errorCode(int errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Payload cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public Payload format(H.Format format) {
            this.format = format;
            return this;
        }

        public Payload status(H.Status status) {
            this.status = status;
            return this;
        }

        public Payload attach(Object attachment) {
            this.attachment = attachment;
            return this;
        }

        public Payload etag(String etag) {
            this.etag = etag;
            return this;
        }

        public String etag() {
            return this.etag;
        }

        public Payload outputEncoding(boolean outputEncoding) {
            this.outputEncoding = outputEncoding;
            return this;
        }

        public boolean outputEncoding() {
            return null != this.outputEncoding && this.outputEncoding != false;
        }
    }
}

