/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.mvc.result;

import org.osgl.$;
import org.osgl.Lang;
import org.osgl.http.H;
import org.osgl.mvc.result.ErrorResult;
import org.osgl.util.Codec;
import org.osgl.util.E;
import org.osgl.util.S;

public class Unauthorized
extends ErrorResult {
    private static final String PAYLOAD_KEY = "401";
    public static final Unauthorized INSTANCE = new Unauthorized();
    private static final Unauthorized _INSTANCE = new Unauthorized(){

        @Override
        protected String realm() {
            Lang.T2 data = (Lang.T2)1.payload().getValue(Unauthorized.PAYLOAD_KEY);
            return null == data ? null : (String)data._1;
        }

        public String getMessage() {
            return 1.payload().message;
        }

        @Override
        public Integer errorCode() {
            return 1.payload().errorCode;
        }

        @Override
        protected Type type() {
            Lang.T2 data = (Lang.T2)1.payload().getValue(Unauthorized.PAYLOAD_KEY);
            return null == data ? null : (Type)((Object)data._2);
        }

        @Override
        public long timestamp() {
            return 1.payload().timestamp;
        }
    };
    private String realm;
    private Type type;

    public Unauthorized() {
        this((String)null);
    }

    public Unauthorized(int errorCode) {
        super(H.Status.UNAUTHORIZED, errorCode);
        this.type = Type.FORM;
    }

    public Unauthorized(int errorCode, String message) {
        super(H.Status.UNAUTHORIZED, (Integer)errorCode, message);
        this.type = Type.FORM;
    }

    public Unauthorized(String realm) {
        super(H.Status.UNAUTHORIZED);
        this.realm = realm;
        this.type = S.blank((String)realm) ? Type.FORM : Type.BASIC;
    }

    public Unauthorized(String realm, boolean digest) {
        super(H.Status.UNAUTHORIZED);
        this.realm = realm;
        Type type = this.type = digest ? Type.DIGEST : Type.BASIC;
        if (digest) {
            throw E.unsupport((String)"Digest access authentication is currently not supported", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(H.Request req, H.Response resp) {
        this.applyBeforeCommitHandler(req, resp);
        try {
            this.applyStatus(resp);
            this.applyCookies(resp);
            this.applyHeaders(resp);
            resp.header("WWW-Authenticate", this.type().header(this));
            this.applyMessage(req, resp);
        }
        finally {
            try {
                resp.commit();
                this.applyAfterCommitHandler(req, resp);
            }
            finally {
                Unauthorized.clearThreadLocals();
            }
        }
    }

    protected Type type() {
        return this.type;
    }

    protected String realm() {
        return this.realm;
    }

    public static Unauthorized get() {
        return INSTANCE;
    }

    public static Unauthorized of(String realm) {
        Unauthorized.touchPayload().putValue(PAYLOAD_KEY, $.T2((Object)realm, (Object)((Object)(S.blank((String)realm) ? Type.FORM : Type.BASIC))));
        return _INSTANCE;
    }

    public static Unauthorized of(int errorCode) {
        Unauthorized.touchPayload().errorCode = errorCode;
        return _INSTANCE;
    }

    public static Unauthorized of(int errorCode, String message) {
        Unauthorized.touchPayload().errorCode(errorCode).message(message);
        return _INSTANCE;
    }

    static enum Type {
        BASIC{

            @Override
            String header(Unauthorized data) {
                StringBuilder sb = S.builder((String)"Basic realm=\"").append(Codec.encodeBase64((String)data.realm())).append("\"");
                return sb.toString();
            }
        }
        ,
        DIGEST{

            @Override
            String header(Unauthorized data) {
                StringBuilder sb = S.builder((String)"Digest realm=\"").append(data.realm()).append("\",\nqop=\"auth,auth-int\",\nnonce=\"").append(S.random((int)34)).append("\",\nopaque=\"").append(S.random((int)32)).append("\"");
                return sb.toString();
            }
        }
        ,
        FORM{

            @Override
            String header(Unauthorized data) {
                return "Form";
            }
        };


        abstract String header(Unauthorized var1);
    }
}

