/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.mvc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.http.HttpConfig;
import org.osgl.mvc.ErrorPageRenderer;
import org.osgl.mvc.result.Result;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Output;
import org.osgl.util.S;

public class MvcConfig
extends HttpConfig {
    public static final String MSG_ID_CREATED = "osgl.result.created";
    public static final String MSG_ID_ACCEPTED = "osgl.result.accepted";
    public static final String MSG_ID_CLIENT_ERROR = "osgl.result.client_error";
    public static final String MSG_ID_BAD_REQUEST = "osgl.result.bad_request";
    public static final String MSG_ID_UNAUTHORIZED = "osgl.result.unauthorized";
    public static final String MSG_ID_PAYMENT_REQUIRED = "osgl.result.payment_required";
    public static final String MSG_ID_FORBIDDEN = "osgl.result.forbidden";
    public static final String MSG_ID_NOT_FOUND = "osgl.result.not_found";
    public static final String MSG_ID_METHOD_NOT_ALLOWED = "osgl.result.method_not_allowed";
    public static final String MSG_ID_NOT_ACCEPTABLE = "osgl.result.not_acceptable";
    public static final String MSG_ID_PROXY_AUTHENTICATION_REQUIRED = "osgl.result.proxy_authentication_required";
    public static final String MSG_ID_REQUREST_TIMEOUT = "osgl.result.request_timeout";
    public static final String MSG_ID_CONFLICT = "osgl.result.conflict";
    public static final String MSG_ID_TOO_MANY_REQUESTS = "osgl.result.too_many_requests";
    public static final String MSG_ID_UNKNOWN_STATUS = "osgl.result.unknown_status";
    public static final String MSG_ID_SERVER_ERROR = "osgl.result.server_error";
    public static final String MSG_ID_NOT_IMPLEMENTED = "osgl.result.not_implemented";
    private static final Map<H.Status, String> messageMap = C.map((Object[])new Object[]{H.Status.ACCEPTED, "osgl.result.accepted", H.Status.CREATED, "osgl.result.created", H.Status.BAD_REQUEST, "osgl.result.bad_request", H.Status.UNAUTHORIZED, "osgl.result.unauthorized", H.Status.PAYMENT_REQUIRED, "osgl.result.payment_required", H.Status.FORBIDDEN, "osgl.result.forbidden", H.Status.NOT_FOUND, "osgl.result.not_found", H.Status.METHOD_NOT_ALLOWED, "osgl.result.method_not_allowed", H.Status.NOT_ACCEPTABLE, "osgl.result.not_acceptable", H.Status.PROXY_AUTHENTICATION_REQUIRED, "osgl.result.proxy_authentication_required", H.Status.REQUEST_TIMEOUT, "osgl.result.request_timeout", H.Status.TOO_MANY_REQUESTS, "osgl.result.too_many_requests", H.Status.CONFLICT, "osgl.result.conflict", H.Status.NOT_IMPLEMENTED, "osgl.result.not_implemented"});
    private static final Map<H.Status, String> enMessageMap = C.map((Object[])new Object[]{H.Status.CREATED, "Created", H.Status.ACCEPTED, "Accepted", H.Status.BAD_REQUEST, "Bad Request", H.Status.PAYMENT_REQUIRED, "Payment Required", H.Status.FORBIDDEN, "Forbidden", H.Status.NOT_FOUND, "Not Found", H.Status.METHOD_NOT_ALLOWED, "Method Not Allowed", H.Status.NOT_ACCEPTABLE, "Not Acceptable", H.Status.PROXY_AUTHENTICATION_REQUIRED, "Proxy Authentication Required", H.Status.REQUEST_TIMEOUT, "Request Timeout", H.Status.CONFLICT, "Conflict", H.Status.TOO_MANY_REQUESTS, "Too Many Requests", H.Status.NOT_IMPLEMENTED, "Not Implemented"});
    public static final String DEF_COOKIE_PREFIX = "OSGL";
    private static final Osgl.Func3<Result, H.Request<?>, H.Response<?>, Void> DUMB_COMMIT_RESULT_LISTENER = new Osgl.F3<Result, H.Request<?>, H.Response<?>, Void>(){

        public Void apply(Result result, H.Request request, H.Response response) throws NotAppliedException, Osgl.Break {
            return null;
        }
    };
    static String sessionCookieName = "OSGL_SESSION";
    static String flashCookieName = "OSGL_FLASH";
    static int sessionExpire = -1;
    static String secret;
    static Osgl.Func2<Output, Object, ?> jsonSerializer;
    static Osgl.Func3<Result, H.Request<?>, H.Response<?>, ?> beforeCommitResultHandler;
    static Osgl.Func3<Result, H.Request<?>, H.Response<?>, ?> afterCommitResultHandler;
    static Osgl.Function<String, String> messageTranlater;
    static Osgl.Func0<H.Format> jsonMediaTypeProvider;
    static boolean renderJsonOutputCharset;
    private static ErrorPageRenderer errorPageRenderer;
    private static boolean localizedErrorMsg;

    public static void cookiePrefix(String prefix) {
        E.illegalArgumentIf((boolean)S.blank((String)prefix));
        sessionCookieName = prefix + "_SESSION";
        prefix = "_FLASH";
        flashCookieName = "_FLASH";
    }

    public static void sessionExpire(int ttl) {
        E.illegalArgumentIf((ttl < 0 ? 1 : 0) != 0);
        sessionExpire = ttl;
    }

    public static void secret(String secret) {
        E.illegalArgumentIf((boolean)S.blank((String)secret));
        MvcConfig.secret = secret;
    }

    public static void renderJsonOutputCharset(boolean b) {
        renderJsonOutputCharset = b;
    }

    public static boolean renderJsonOutputCharset() {
        return renderJsonOutputCharset;
    }

    public static void jsonMediaTypeProvider(Osgl.Func0<H.Format> provider) {
        jsonMediaTypeProvider = (Osgl.Func0)$.notNull(provider);
    }

    public static Osgl.Func0<H.Format> jsonMediaTypeProvider() {
        return jsonMediaTypeProvider;
    }

    public static void jsonSerializer(Osgl.Func2<Output, Object, ?> serializer) {
        jsonSerializer = (Osgl.Func2)$.notNull(serializer);
    }

    public static void beforeCommitResultHandler(Osgl.Func3<Result, H.Request<?>, H.Response<?>, ?> beforeCommitResultHandler) {
        MvcConfig.beforeCommitResultHandler = (Osgl.Func3)$.notNull(beforeCommitResultHandler);
    }

    public static void applyBeforeCommitResultHandler(Result result, H.Request req, H.Response resp) {
        beforeCommitResultHandler.apply((Object)result, (Object)req, (Object)resp);
    }

    public static void afterCommitResultHandler(Osgl.Func3<Result, H.Request<?>, H.Response<?>, ?> afterCommitResultHandler) {
        MvcConfig.afterCommitResultHandler = (Osgl.Func3)$.notNull(afterCommitResultHandler);
    }

    public static void applyAfterCommitResultHandler(Result result, H.Request<?> req, H.Response<?> resp) {
        afterCommitResultHandler.apply((Object)result, req, resp);
    }

    public static void messageTranslater(Osgl.Function<String, String> translater) {
        messageTranlater = (Osgl.Function)$.notNull(translater);
    }

    public static Osgl.Function<String, String> messageTranslater() {
        return messageTranlater;
    }

    public static Osgl.Visitor<Output> jsonSerializer(final Object v) {
        return new Osgl.Visitor<Output>(){

            public void visit(Output sink) throws Osgl.Break {
                jsonSerializer.apply((Object)sink, v);
            }
        };
    }

    public static void errorPageRenderer(ErrorPageRenderer renderer) {
        E.NPE((Object)((Object)renderer));
        errorPageRenderer = renderer;
    }

    public static ErrorPageRenderer errorPageRenderer() {
        return errorPageRenderer;
    }

    public static void enableLocalizedErrorMsg() {
        localizedErrorMsg = true;
    }

    public static boolean localizedErrorMsg() {
        return localizedErrorMsg;
    }

    public static String errorMessage(H.Status status) {
        String msg;
        boolean i18n = MvcConfig.localizedErrorMsg();
        String string = msg = i18n ? messageMap.get(status) : enMessageMap.get(status);
        if (null == msg) {
            msg = status.isClientError() ? (i18n ? MSG_ID_CLIENT_ERROR : "Client Error") : (status.isServerError() ? (i18n ? MSG_ID_SERVER_ERROR : "Server Error") : "Unknown status");
        }
        if (i18n) {
            msg = (String)messageTranlater.apply((Object)msg);
        }
        return msg;
    }

    public static String errorMessage(int code) {
        return MvcConfig.errorMessage(H.Status.of((int)code));
    }

    static {
        jsonSerializer = new Osgl.Func2<Output, Object, Void>(){

            public Void apply(Output sink, Object o) throws NotAppliedException, Osgl.Break {
                if (o instanceof CharSequence) {
                    sink.append((CharSequence)o);
                } else {
                    try {
                        JSON.writeJSONString((OutputStream)sink.asOutputStream(), (Object)o, (SerializerFeature[])new SerializerFeature[0]);
                    }
                    catch (IOException e) {
                        throw E.ioException((IOException)e);
                    }
                }
                return null;
            }
        };
        beforeCommitResultHandler = DUMB_COMMIT_RESULT_LISTENER;
        afterCommitResultHandler = DUMB_COMMIT_RESULT_LISTENER;
        messageTranlater = Osgl.F.identity();
        jsonMediaTypeProvider = new Osgl.Func0<H.Format>(){

            public H.Format apply() throws NotAppliedException, Osgl.Break {
                return H.Format.JSON;
            }
        };
        renderJsonOutputCharset = false;
        errorPageRenderer = new ErrorPageRenderer();
        localizedErrorMsg = false;
    }
}

