/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.mvc.result;

import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.http.H;
import org.osgl.mvc.result.Result;
import org.osgl.util.E;
import org.osgl.util.Output;
import org.osgl.util.S;

public abstract class RenderContent
extends Result {
    private String content;
    private Osgl.Visitor<Output> contentWriter;
    private H.Format format;
    private boolean outputEncoding;

    protected RenderContent(H.Format format) {
        this("", format, true);
    }

    protected RenderContent(String content, H.Format format) {
        this(content, format, true);
    }

    protected RenderContent(Osgl.Visitor<Output> contentWriter, H.Format format) {
        this(contentWriter, format, true);
    }

    protected RenderContent(H.Status status, String content, H.Format format) {
        this(status, content, format, true);
    }

    protected RenderContent(H.Status status, Osgl.Visitor<Output> contentWriter, H.Format format) {
        this(status, contentWriter, format, true);
    }

    protected RenderContent(String content, H.Format format, boolean outputEncoding) {
        this(H.Status.OK, content, format, outputEncoding);
    }

    protected RenderContent(Osgl.Visitor<Output> contentWriter, H.Format format, boolean outputEncoding) {
        this(H.Status.OK, contentWriter, format, outputEncoding);
    }

    protected RenderContent(H.Status status, String content, H.Format format, boolean outputEncoding) {
        super(status);
        E.NPE((Object)format);
        this.content = content;
        this.format = format;
        this.outputEncoding = outputEncoding;
    }

    protected RenderContent(H.Status status, Osgl.Visitor<Output> contentWriter, H.Format format, boolean outputEncoding) {
        super(status);
        E.NPE((Object)format);
        this.contentWriter = (Osgl.Visitor)$.notNull(contentWriter);
        this.format = format;
        this.outputEncoding = outputEncoding;
    }

    protected void setContentType(H.Response resp) {
        String encoding;
        String s = this.format().contentType();
        if (this.isOutputEncoding() && S.notBlank((String)(encoding = resp.characterEncoding()))) {
            s = S.builder((String)s).append("; charset=").append(encoding).toString();
        }
        resp.initContentType(s);
    }

    protected boolean isOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(boolean outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public H.Format format() {
        return this.format;
    }

    public String content() {
        return this.content;
    }

    public Osgl.Visitor<Output> contentWriter() {
        return this.contentWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(H.Request req, H.Response resp) {
        try {
            this.applyStatus(resp);
            this.setContentType(resp);
            this.applyCookies(resp);
            this.applyHeaders(resp);
            this.applyBeforeCommitHandler(req, resp);
            Osgl.Visitor<Output> contentWriter = this.contentWriter();
            if (null != contentWriter) {
                contentWriter.visit((Object)resp.output());
            } else {
                resp.writeContent(this.content());
            }
        }
        finally {
            try {
                resp.commit();
                this.applyAfterCommitHandler(req, resp);
            }
            finally {
                RenderContent.clearThreadLocals();
            }
        }
    }
}

