/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.mvc.result;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.http.H;
import org.osgl.mvc.result.Result;
import org.osgl.storage.ISObject;
import org.osgl.storage.impl.SObject;
import org.osgl.util.E;
import org.osgl.util.Output;
import org.osgl.util.S;

public class RenderBinary
extends Result {
    private Disposition disposition = Disposition.inline;
    private long length;
    private String name;
    private SObject binary;
    private String contentType;
    private Lang.Visitor<Output> contentWriter;

    public RenderBinary(byte[] bytes) {
        this.binary = SObject.of((byte[])bytes);
        this.length = bytes.length;
        this.disposition = Disposition.inline;
    }

    public RenderBinary(byte[] bytes, String attachmentName) {
        this.binary = SObject.of((byte[])bytes);
        this.length = bytes.length;
        this.name = attachmentName;
        this.disposition = Disposition.of(S.notBlank((String)attachmentName));
    }

    public RenderBinary(InputStream is, String name) {
        this(is, name, false);
    }

    public RenderBinary(InputStream is, String name, long length) {
        this(is, name, length, false);
    }

    public RenderBinary(InputStream is, String name, boolean inline) {
        this(is, name, null, inline);
    }

    public RenderBinary(InputStream is, String name, String contentType, boolean inline) {
        this.binary = SObject.of((String)name, (InputStream)is);
        this.name = name;
        this.contentType = contentType;
        this.disposition = Disposition.of(inline);
    }

    public RenderBinary(InputStream is, String name, long length, String contentType, boolean inline) {
        this.binary = SObject.of((String)name, (InputStream)is);
        this.name = name;
        this.contentType = contentType;
        this.disposition = Disposition.of(inline);
        this.length = length;
    }

    public RenderBinary(InputStream is, String name, long length, boolean inline) {
        this.binary = SObject.of((String)name, (InputStream)is);
        this.name = name;
        this.length = length;
        this.disposition = Disposition.of(inline);
    }

    public RenderBinary(File file, String name) {
        this(file, name, false);
    }

    public RenderBinary(File file) {
        this(file, file.getName(), true);
    }

    public RenderBinary(File file, String name, boolean inline) {
        this.binary = SObject.of((String)name, (File)((File)$.requireNotNull((Object)file)));
        this.name = name;
        this.length = file.length();
        this.disposition = Disposition.of(inline);
    }

    public RenderBinary(Lang.Visitor<Output> contentWriter) {
        this.contentWriter = (Lang.Visitor)$.requireNotNull(contentWriter);
    }

    public RenderBinary contentType(H.Format contentType) {
        this.contentType = contentType.contentType();
        return this;
    }

    public RenderBinary contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public RenderBinary name(String attachmentName) {
        this.name = attachmentName;
        this.disposition = Disposition.of(S.notBlank((String)attachmentName));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(H.Request req, H.Response resp) {
        boolean hasName = S.notBlank((String)this.name);
        try {
            this.applyCookies(resp);
            this.applyHeaders(resp);
            if (null != this.contentType) {
                resp.contentType(this.contentType);
            } else {
                H.Format format;
                String ext;
                boolean set = false;
                if (hasName && S.notBlank((String)(ext = S.afterLast((String)this.name, (String)"."))) && null != (format = H.Format.of((String)ext))) {
                    resp.initContentType(format.contentType());
                    set = true;
                }
                if (!set) {
                    resp.initContentType("application/octet-stream");
                }
            }
            if (!resp.containsHeader("Content-Disposition")) {
                resp.contentDisposition(this.name, this.disposition.isInline());
            }
            if (!resp.containsHeader("Content-Length") && 0L < this.length) {
                resp.header("Content-Length", S.string((long)this.length));
            }
            this.applyStatus(resp);
            this.applyBeforeCommitHandler(req, resp);
            if (null != this.binary) {
                resp.writeBinary((ISObject)this.binary);
            } else {
                this.contentWriter.apply((Object)resp.output());
            }
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e);
        }
        finally {
            try {
                resp.commit();
                this.applyAfterCommitHandler(req, resp);
            }
            finally {
                RenderBinary.clearThreadLocals();
            }
        }
    }

    private boolean canAsciiEncode(String string) {
        CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
        return asciiEncoder.canEncode(string);
    }

    private static enum Disposition {
        inline,
        attachment;


        public boolean isInline() {
            return inline == this;
        }

        public boolean isAttachment() {
            return attachment == this;
        }

        public static Disposition of(boolean inline) {
            return inline ? Disposition.inline : attachment;
        }
    }
}

