/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.gradle.tasks;

import com.google.common.base.Strings;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.owasp.dependencycheck.gradle.extension.DependencyCheckExtension;
import org.owasp.dependencycheck.gradle.service.SlackNotificationSenderService;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.Settings;

public abstract class ConfiguredTask
extends DefaultTask
implements GroovyObject {
    @org.gradle.api.tasks.Internal
    private DependencyCheckExtension config;
    @org.gradle.api.tasks.Internal
    private Settings settings;
    @org.gradle.api.tasks.Internal
    private String PROPERTIES_FILE;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ConfiguredTask() {
        MetaClass metaClass;
        String string;
        DependencyCheckExtension dependencyCheckExtension;
        this.config = dependencyCheckExtension = (DependencyCheckExtension)ScriptBytecodeAdapter.castToType((Object)this.getProject().getExtensions().findByName("dependencyCheck"), DependencyCheckExtension.class);
        this.PROPERTIES_FILE = string = "task.properties";
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeSettings() {
        boolean bl;
        Settings settings;
        this.settings = settings = new Settings();
        InputStream taskProperties = null;
        try {
            try {
                InputStream inputStream;
                taskProperties = inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.PROPERTIES_FILE);
                this.settings.mergeProperties(taskProperties);
            }
            catch (IOException ex) {
                this.getLogger().warn("Unable to load the dependency-check gradle task.properties file.");
                this.getLogger().debug("", (Throwable)ex);
            }
            bl = taskProperties != null;
        }
        catch (Throwable throwable) {
            if (!(taskProperties != null)) throw throwable;
            try {
                taskProperties.close();
                throw throwable;
            }
            catch (IOException ex) {
                this.getLogger().debug("", (Throwable)ex);
                throw throwable;
            }
        }
        if (bl) {
            try {
                taskProperties.close();
            }
            catch (IOException ex) {
                this.getLogger().debug("", (Throwable)ex);
            }
        }
        this.settings.setBooleanIfNotNull(Settings.KEYS.AUTO_UPDATE, this.config.getAutoUpdate());
        String[] suppressionLists = this.determineSuppressions(this.config.getSuppressionFiles(), this.config.getSuppressionFile());
        this.settings.setArrayIfNotEmpty(Settings.KEYS.SUPPRESSION_FILE, suppressionLists);
        this.settings.setStringIfNotEmpty(Settings.KEYS.SUPPRESSION_FILE_USER, this.config.getSuppressionFileUser());
        this.settings.setStringIfNotEmpty(Settings.KEYS.SUPPRESSION_FILE_PASSWORD, this.config.getSuppressionFilePassword());
        this.settings.setStringIfNotEmpty(Settings.KEYS.HINTS_FILE, this.config.getHintsFile());
        this.configureProxy(this.settings);
        this.configureSlack(this.settings);
        this.settings.setStringIfNotNull(Settings.KEYS.DATA_DIRECTORY, this.config.getData().getDirectory());
        this.settings.setStringIfNotEmpty(Settings.KEYS.DB_DRIVER_NAME, this.config.getData().getDriver());
        this.settings.setStringIfNotEmpty(Settings.KEYS.DB_DRIVER_PATH, this.config.getData().getDriverPath());
        this.settings.setStringIfNotEmpty(Settings.KEYS.DB_CONNECTION_STRING, this.config.getData().getConnectionString());
        this.settings.setStringIfNotEmpty(Settings.KEYS.DB_USER, this.config.getData().getUsername());
        this.settings.setStringIfNotEmpty(Settings.KEYS.DB_PASSWORD, this.config.getData().getPassword());
        this.settings.setStringIfNotEmpty(Settings.KEYS.NVD_API_KEY, this.config.getNvd().getApiKey());
        this.settings.setStringIfNotEmpty(Settings.KEYS.NVD_API_ENDPOINT, this.config.getNvd().getEndpoint());
        this.settings.setIntIfNotNull(Settings.KEYS.NVD_API_DELAY, this.config.getNvd().getDelay());
        this.settings.setIntIfNotNull(Settings.KEYS.NVD_API_RESULTS_PER_PAGE, this.config.getNvd().getResultsPerPage());
        this.settings.setIntIfNotNull(Settings.KEYS.NVD_API_MAX_RETRY_COUNT, this.config.getNvd().getMaxRetryCount());
        this.settings.setIntIfNotNull(Settings.KEYS.NVD_API_VALID_FOR_HOURS, this.config.getNvd().getValidForHours());
        this.settings.setStringIfNotEmpty(Settings.KEYS.NVD_API_DATAFEED_URL, this.config.getNvd().getDatafeedUrl());
        if (DefaultTypeTransformation.booleanUnbox((Object)this.config.getNvd().getDatafeedUser()) && DefaultTypeTransformation.booleanUnbox((Object)this.config.getNvd().getDatafeedPassword())) {
            this.settings.setStringIfNotEmpty(Settings.KEYS.NVD_API_DATAFEED_USER, this.config.getNvd().getDatafeedUser());
            this.settings.setStringIfNotEmpty(Settings.KEYS.NVD_API_DATAFEED_PASSWORD, this.config.getNvd().getDatafeedPassword());
        }
        this.settings.setBooleanIfNotNull(Settings.KEYS.DOWNLOADER_QUICK_QUERY_TIMESTAMP, this.config.getQuickQueryTimestamp());
        this.settings.setFloat(Settings.KEYS.JUNIT_FAIL_ON_CVSS, this.config.getJunitFailOnCVSS().floatValue());
        this.settings.setBooleanIfNotNull(Settings.KEYS.HOSTED_SUPPRESSIONS_ENABLED, this.config.getHostedSuppressions().getEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.HOSTED_SUPPRESSIONS_FORCEUPDATE, this.config.getHostedSuppressions().getForceupdate());
        this.settings.setStringIfNotNull(Settings.KEYS.HOSTED_SUPPRESSIONS_URL, this.config.getHostedSuppressions().getUrl());
        if (this.config.getHostedSuppressions().getValidForHours() != null) {
            if (!ScriptBytecodeAdapter.compareGreaterThanEqual((Object)this.config.getHostedSuppressions().getValidForHours(), (Object)0)) throw (Throwable)new InvalidUserDataException("Invalid setting: `validForHours` must be 0 or greater");
            this.settings.setInt(Settings.KEYS.HOSTED_SUPPRESSIONS_VALID_FOR_HOURS, this.config.getHostedSuppressions().getValidForHours().intValue());
        }
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_JAR_ENABLED, this.config.getAnalyzers().getJarEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NUSPEC_ENABLED, this.config.getAnalyzers().getNuspecEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_OSSINDEX_ENABLED, this.select(this.config.getAnalyzers().getOssIndex().getEnabled(), this.config.getAnalyzers().getOssIndexEnabled()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_OSSINDEX_WARN_ONLY_ON_REMOTE_ERRORS, this.config.getAnalyzers().getOssIndex().getWarnOnlyOnRemoteErrors());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_OSSINDEX_ENABLED, this.config.getAnalyzers().getOssIndex().getEnabled());
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_OSSINDEX_USER, this.config.getAnalyzers().getOssIndex().getUsername());
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_OSSINDEX_PASSWORD, this.config.getAnalyzers().getOssIndex().getPassword());
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_OSSINDEX_URL, this.config.getAnalyzers().getOssIndex().getUrl());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_CENTRAL_ENABLED, this.config.getAnalyzers().getCentralEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NEXUS_ENABLED, this.config.getAnalyzers().getNexusEnabled());
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_NEXUS_URL, this.config.getAnalyzers().getNexusUrl());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NEXUS_USES_PROXY, this.config.getAnalyzers().getNexusUsesProxy());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_EXPERIMENTAL_ENABLED, this.config.getAnalyzers().getExperimentalEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_ARCHIVE_ENABLED, this.config.getAnalyzers().getArchiveEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_KNOWN_EXPLOITED_ENABLED, this.config.getAnalyzers().getKnownExploitedEnabled());
        this.settings.setStringIfNotNull(Settings.KEYS.KEV_URL, this.config.getAnalyzers().getKnownExploitedURL());
        this.settings.setIntIfNotNull(Settings.KEYS.KEV_CHECK_VALID_FOR_HOURS, this.config.getAnalyzers().getKnownExploitedValidForHours());
        this.settings.setStringIfNotEmpty(Settings.KEYS.ADDITIONAL_ZIP_EXTENSIONS, this.config.getAnalyzers().getZipExtensions());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_ASSEMBLY_ENABLED, this.config.getAnalyzers().getAssemblyEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_MSBUILD_PROJECT_ENABLED, this.config.getAnalyzers().getMsbuildEnabled());
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_ASSEMBLY_DOTNET_PATH, this.config.getAnalyzers().getPathToDotnet());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_GOLANG_DEP_ENABLED, this.config.getAnalyzers().getGolangDepEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_GOLANG_MOD_ENABLED, this.config.getAnalyzers().getGolangModEnabled());
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_GOLANG_PATH, this.config.getAnalyzers().getPathToGo());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_COCOAPODS_ENABLED, this.config.getAnalyzers().getCocoapodsEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_SWIFT_PACKAGE_MANAGER_ENABLED, this.config.getAnalyzers().getSwiftEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_DART_ENABLED, this.config.getAnalyzers().getDartEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_SWIFT_PACKAGE_RESOLVED_ENABLED, this.config.getAnalyzers().getSwiftPackageResolvedEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_BUNDLE_AUDIT_ENABLED, this.config.getAnalyzers().getBundleAuditEnabled());
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_BUNDLE_AUDIT_PATH, this.config.getAnalyzers().getPathToBundleAudit());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_PYTHON_DISTRIBUTION_ENABLED, this.config.getAnalyzers().getPyDistributionEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_PYTHON_PACKAGE_ENABLED, this.config.getAnalyzers().getPyPackageEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_RUBY_GEMSPEC_ENABLED, this.config.getAnalyzers().getRubygemsEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_OPENSSL_ENABLED, this.config.getAnalyzers().getOpensslEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_CMAKE_ENABLED, this.config.getAnalyzers().getCmakeEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_AUTOCONF_ENABLED, this.config.getAnalyzers().getAutoconfEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_COMPOSER_LOCK_ENABLED, this.config.getAnalyzers().getComposerEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_COMPOSER_LOCK_SKIP_DEV, this.config.getAnalyzers().getComposerSkipDev());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_CPANFILE_ENABLED, this.config.getAnalyzers().getCpanEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NUGETCONF_ENABLED, this.config.getAnalyzers().getNugetconfEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NODE_PACKAGE_ENABLED, this.select(this.config.getAnalyzers().getNodePackage().getEnabled(), this.config.getAnalyzers().getNodeEnabled()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NODE_PACKAGE_SKIPDEV, this.config.getAnalyzers().getNodePackage().getSkipDevDependencies());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NODE_AUDIT_ENABLED, this.select(this.config.getAnalyzers().getNodeAudit().getEnabled(), this.config.getAnalyzers().getNodeAuditEnabled()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NODE_AUDIT_USE_CACHE, this.config.getAnalyzers().getNodeAudit().getUseCache());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NODE_AUDIT_SKIPDEV, this.config.getAnalyzers().getNodeAudit().getSkipDevDependencies());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_YARN_AUDIT_ENABLED, this.config.getAnalyzers().getNodeAudit().getYarnEnabled());
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_YARN_PATH, this.config.getAnalyzers().getNodeAudit().getYarnPath());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_PNPM_AUDIT_ENABLED, this.config.getAnalyzers().getNodeAudit().getPnpmEnabled());
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_PNPM_PATH, this.config.getAnalyzers().getNodeAudit().getPnpmPath());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_RETIREJS_ENABLED, this.config.getAnalyzers().getRetirejs().getEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_RETIREJS_FORCEUPDATE, this.config.getAnalyzers().getRetirejs().getForceupdate());
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_RETIREJS_REPO_JS_URL, this.config.getAnalyzers().getRetirejs().getRetireJsUrl());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_RETIREJS_FILTER_NON_VULNERABLE, this.config.getAnalyzers().getRetirejs().getFilterNonVulnerable());
        this.settings.setArrayIfNotEmpty(Settings.KEYS.ANALYZER_RETIREJS_FILTERS, this.config.getAnalyzers().getRetirejs().getFilters());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_ENABLED, this.config.getAnalyzers().getArtifactory().getEnabled());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_PARALLEL_ANALYSIS, this.config.getAnalyzers().getArtifactory().getParallelAnalysis());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_USES_PROXY, this.config.getAnalyzers().getArtifactory().getUsesProxy());
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_URL, this.config.getAnalyzers().getArtifactory().getUrl());
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_API_TOKEN, this.config.getAnalyzers().getArtifactory().getApiToken());
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_API_USERNAME, this.config.getAnalyzers().getArtifactory().getUsername());
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_BEARER_TOKEN, this.config.getAnalyzers().getArtifactory().getBearerToken());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NODE_AUDIT_USE_CACHE, this.config.getCache().getNodeAudit());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_CENTRAL_USE_CACHE, this.config.getCache().getCentral());
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_OSSINDEX_USE_CACHE, this.config.getCache().getOssIndex());
        Downloader.getInstance().configure(this.settings);
    }

    private void configureSlack(Settings settings) {
        settings.setBooleanIfNotNull(SlackNotificationSenderService.SLACK__WEBHOOK__ENABLED, this.config.getSlack().getEnabled());
        settings.setStringIfNotEmpty(SlackNotificationSenderService.SLACK__WEBHOOK__URL, this.config.getSlack().getWebhookUrl());
    }

    private void configureProxy(Settings settings) {
        String proxyHost = System.getProperty("https.proxyHost", System.getProperty("http.proxyHost"));
        if (!Strings.isNullOrEmpty((String)proxyHost)) {
            String proxyPort = System.getProperty("https.proxyPort", System.getProperty("http.proxyPort"));
            String nonProxyHosts = System.getProperty("https.nonProxyHosts", System.getProperty("http.nonProxyHosts"));
            String proxyUser = System.getProperty("https.proxyUser", System.getProperty("http.proxyUser"));
            String proxyPassword = System.getProperty("https.proxyPassword", System.getProperty("http.proxyPassword"));
            String string = proxyHost;
            this.config.getProxy().setServer(string);
            try {
                int n = Integer.parseInt(proxyPort);
                this.config.getProxy().setPort(n);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{proxyPort}, new String[]{"Unable to convert the configured `http.proxyPort` to a number: ", ""})));
            }
            if (!Strings.isNullOrEmpty((String)proxyUser)) {
                String string2 = proxyUser;
                this.config.getProxy().setUsername(string2);
            }
            if (!Strings.isNullOrEmpty((String)proxyPassword)) {
                String string3 = proxyPassword;
                this.config.getProxy().setPassword(string3);
            }
            if (!Strings.isNullOrEmpty((String)nonProxyHosts)) {
                List list = StringGroovyMethods.tokenize((CharSequence)nonProxyHosts, (CharSequence)"|");
                this.config.getProxy().setNonProxyHosts(list);
            }
        }
        settings.setStringIfNotEmpty(Settings.KEYS.PROXY_SERVER, this.config.getProxy().getServer());
        settings.setStringIfNotEmpty(Settings.KEYS.PROXY_PORT, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.config.getProxy().getPort()}, new String[]{"", ""})));
        settings.setStringIfNotEmpty(Settings.KEYS.PROXY_USERNAME, this.config.getProxy().getUsername());
        settings.setStringIfNotEmpty(Settings.KEYS.PROXY_PASSWORD, this.config.getProxy().getPassword());
        settings.setStringIfNotEmpty(Settings.KEYS.PROXY_NON_PROXY_HOSTS, DefaultGroovyMethods.join(this.config.getProxy().getNonProxyHosts(), (String)"|"));
    }

    private String[] determineSuppressions(Collection<String> suppressionFiles, String suppressionFile) {
        List files = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (suppressionFiles != null) {
            Collection<String> collection = suppressionFiles;
            Iterator<String> iterator = collection != null ? collection.iterator() : null;
            String sf = null;
            Iterator<String> iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    sf = ShortTypeHandling.castToString((Object)iterator2.next());
                    files.add(sf.toString());
                }
            }
        }
        if (suppressionFile != null) {
            files.add(suppressionFile);
        }
        return (String[])ScriptBytecodeAdapter.castToType((Object)files.toArray((Object[])ScriptBytecodeAdapter.castToType((Object)new String[0], Object[].class)), String[].class);
    }

    private Boolean select(Boolean current, Boolean deprecated) {
        return current != null ? current : deprecated;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ConfiguredTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public DependencyCheckExtension getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(DependencyCheckExtension dependencyCheckExtension) {
        this.config = dependencyCheckExtension;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public String getPROPERTIES_FILE() {
        return this.PROPERTIES_FILE;
    }

    @Generated
    public void setPROPERTIES_FILE(String string) {
        this.PROPERTIES_FILE = string;
    }
}

