/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils.scarf;

import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.Settings;

public class TelemetryCollector {
    private static final String BASE_URL = "https://dependency-check.gateway.scarf.sh/scan/";
    private static final AtomicBoolean telemetrySubmitted = new AtomicBoolean(false);

    public static void send(Settings settings) {
        try {
            String tool = settings.getString("odc.application.name", "dependency-check");
            String version = settings.getString("odc.application.version", "Unknown");
            TelemetryCollector.send(settings, tool, version);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void send(Settings settings, String tool, String version) {
        if (!telemetrySubmitted.compareAndSet(false, true)) {
            return;
        }
        if (System.getenv("SCARF_NO_ANALYTICS") != null && System.getenv("SCARF_NO_ANALYTICS").equalsIgnoreCase("true") || System.getenv("DO_NOT_TRACK") != null && System.getenv("DO_NOT_TRACK").equalsIgnoreCase("true") || System.getProperty("SCARF_NO_ANALYTICS") != null && System.getProperty("SCARF_NO_ANALYTICS").equalsIgnoreCase("true") || System.getProperty("DO_NOT_TRACK") != null && System.getProperty("DO_NOT_TRACK").equalsIgnoreCase("true")) {
            return;
        }
        try {
            URL telemetryUrl = new URL(BASE_URL + URLEncoder.encode(tool, StandardCharsets.UTF_8) + "/" + URLEncoder.encode(version, StandardCharsets.UTF_8));
            Thread telemetryThread = TelemetryCollector.createThread(settings, telemetryUrl);
            telemetryThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Thread createThread(final Settings settings, final URL url) {
        Thread telemetryThread = new Thread("telemetry-thread"){

            @Override
            public void run() {
                try {
                    Downloader downloader = Downloader.getInstance();
                    downloader.configure(settings);
                    downloader.fetchContent(url, StandardCharsets.UTF_8);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        telemetryThread.setDaemon(true);
        return telemetryThread;
    }
}

