/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.ldap.credentials.authenticator;

import org.ldaptive.Credential;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;
import org.pac4j.core.exception.AccountNotFoundException;
import org.pac4j.core.exception.BadCredentialsException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.pac4j.http.credentials.authenticator.UsernamePasswordAuthenticator;
import org.pac4j.ldap.profile.LdapProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthenticator
implements UsernamePasswordAuthenticator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Authenticator ldapAuthenticator;
    private String attributes = "";

    public LdapAuthenticator() {
    }

    public LdapAuthenticator(Authenticator ldapAuthenticator) {
        this.ldapAuthenticator = ldapAuthenticator;
    }

    public LdapAuthenticator(Authenticator ldapAuthenticator, String attributes) {
        this.ldapAuthenticator = ldapAuthenticator;
        this.attributes = attributes;
    }

    public void validate(UsernamePasswordCredentials credentials) {
        AuthenticationResponse response;
        CommonHelper.assertNotNull((String)"ldapAuthenticator", (Object)this.ldapAuthenticator);
        CommonHelper.assertNotNull((String)"attributes", (Object)this.attributes);
        String username = credentials.getUsername();
        String[] ldapAttributes = this.attributes.split(",");
        try {
            this.logger.debug("Attempting LDAP authentication for: {}", (Object)credentials);
            AuthenticationRequest request = new AuthenticationRequest(username, new Credential(credentials.getPassword()), ldapAttributes);
            response = this.ldapAuthenticator.authenticate(request);
        }
        catch (LdapException e) {
            throw new TechnicalException("Unexpected LDAP error", (Throwable)e);
        }
        this.logger.debug("LDAP response: {}", (Object)response);
        if (((Boolean)response.getResult()).booleanValue()) {
            LdapProfile profile = this.createProfile(username, ldapAttributes, response.getLdapEntry());
            credentials.setUserProfile((UserProfile)profile);
            return;
        }
        if (AuthenticationResultCode.DN_RESOLUTION_FAILURE == response.getAuthenticationResultCode()) {
            throw new AccountNotFoundException(username + " not found");
        }
        throw new BadCredentialsException("Invalid credentials for: " + username);
    }

    protected LdapProfile createProfile(String username, String[] ldapAttributes, LdapEntry entry) {
        LdapProfile profile = new LdapProfile();
        profile.setId(username);
        for (String ldapAttribute : ldapAttributes) {
            LdapAttribute entryAttribute = entry.getAttribute(ldapAttribute);
            if (entryAttribute == null) continue;
            this.logger.debug("Found attribute: {}", (Object)ldapAttribute);
            if (entryAttribute.size() > 1) {
                profile.addAttribute(ldapAttribute, entryAttribute.getStringValues());
                continue;
            }
            profile.addAttribute(ldapAttribute, entryAttribute.getStringValue());
        }
        return profile;
    }

    public Authenticator getLdapAuthenticator() {
        return this.ldapAuthenticator;
    }

    public void setLdapAuthenticator(Authenticator ldapAuthenticator) {
        this.ldapAuthenticator = ldapAuthenticator;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }
}

