/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.openid.redirect;

import java.util.List;
import org.openid4java.OpenIDException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ax.FetchRequest;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.redirect.RedirectActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.openid.client.YahooOpenIdClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YahooRedirectActionBuilder
implements RedirectActionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(YahooRedirectActionBuilder.class);
    private static final String YAHOO_GENERIC_USER_IDENTIFIER = "https://me.yahoo.com";
    private YahooOpenIdClient client;

    public YahooRedirectActionBuilder(YahooOpenIdClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.client = client;
    }

    public RedirectAction redirect(WebContext context) {
        try {
            List discoveries = this.client.getConsumerManager().discover(YAHOO_GENERIC_USER_IDENTIFIER);
            DiscoveryInformation discoveryInformation = this.client.getConsumerManager().associate(discoveries);
            context.getSessionStore().set(context, this.client.getDiscoveryInformationSessionAttributeName(), (Object)discoveryInformation);
            AuthRequest authRequest = this.client.getConsumerManager().authenticate(discoveryInformation, this.client.computeFinalCallbackUrl(context));
            FetchRequest fetchRequest = this.getFetchRequest();
            if (fetchRequest != null) {
                authRequest.addExtension((MessageExtension)fetchRequest);
            }
            String redirectionUrl = authRequest.getDestinationUrl(true);
            logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
            return RedirectAction.redirect((String)redirectionUrl);
        }
        catch (OpenIDException e) {
            throw new TechnicalException("OpenID exception", (Throwable)e);
        }
    }

    protected FetchRequest getFetchRequest() throws MessageException {
        FetchRequest fetchRequest = FetchRequest.createFetchRequest();
        fetchRequest.addAttribute("email", "http://axschema.org/contact/email", true);
        fetchRequest.addAttribute("fullname", "http://axschema.org/namePerson", true);
        fetchRequest.addAttribute("language", "http://axschema.org/pref/language", true);
        fetchRequest.addAttribute("image", "http://axschema.org/media/image/default", true);
        logger.debug("fetchRequest: {}", (Object)fetchRequest);
        return fetchRequest;
    }
}

