/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import org.parboiled.Action;
import org.parboiled.BaseActions;
import org.parboiled.Rule;
import org.parboiled.annotations.Cached;
import org.parboiled.annotations.DontExtend;
import org.parboiled.annotations.DontLabel;
import org.parboiled.annotations.SuppressNode;
import org.parboiled.annotations.SuppressSubnodes;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Utils;
import org.parboiled.errors.GrammarException;
import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.AnyMatcher;
import org.parboiled.matchers.AnyOfMatcher;
import org.parboiled.matchers.CharIgnoreCaseMatcher;
import org.parboiled.matchers.CharMatcher;
import org.parboiled.matchers.CharRangeMatcher;
import org.parboiled.matchers.EmptyMatcher;
import org.parboiled.matchers.FirstOfMatcher;
import org.parboiled.matchers.FirstOfStringsMatcher;
import org.parboiled.matchers.NothingMatcher;
import org.parboiled.matchers.OneOrMoreMatcher;
import org.parboiled.matchers.OptionalMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.StringMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.matchers.ZeroOrMoreMatcher;
import org.parboiled.support.Characters;
import org.parboiled.support.Checks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseParser<V>
extends BaseActions<V> {
    public static final Rule EOI = new CharMatcher('\uffff');
    public static final Rule INDENT = new CharMatcher('\ufdd0');
    public static final Rule DEDENT = new CharMatcher('\ufdd1');
    public static final Rule ANY = new AnyMatcher();
    public static final Rule EMPTY = new EmptyMatcher();
    public static final Rule NOTHING = new NothingMatcher();

    public <P extends BaseParser<V>> P newInstance() {
        throw new UnsupportedOperationException("Illegal parser instance, you have to use Parboiled.createParser(...) to create your parser instance!");
    }

    @Cached
    @DontLabel
    public Rule Ch(char c) {
        return new CharMatcher(c);
    }

    @Cached
    @DontLabel
    public Rule IgnoreCase(char c) {
        if (Character.isLowerCase(c) == Character.isUpperCase(c)) {
            return this.Ch(c);
        }
        return new CharIgnoreCaseMatcher(c);
    }

    @Cached
    @DontLabel
    public Rule CharRange(char cLow, char cHigh) {
        return cLow == cHigh ? this.Ch(cLow) : new CharRangeMatcher(cLow, cHigh);
    }

    @DontLabel
    public Rule AnyOf(String characters) {
        Preconditions.checkArgNotNull((Object)characters, (String)"characters");
        return this.AnyOf(characters.toCharArray());
    }

    @DontLabel
    public Rule AnyOf(char[] characters) {
        Preconditions.checkArgNotNull((Object)characters, (String)"characters");
        Preconditions.checkArgument((characters.length > 0 ? 1 : 0) != 0);
        return characters.length == 1 ? this.Ch(characters[0]) : this.AnyOf(Characters.of((char[])characters));
    }

    @Cached
    @DontLabel
    public Rule AnyOf(Characters characters) {
        Preconditions.checkArgNotNull((Object)characters, (String)"characters");
        if (!characters.isSubtractive() && characters.getChars().length == 1) {
            return this.Ch(characters.getChars()[0]);
        }
        if (characters.equals((Object)Characters.NONE)) {
            return NOTHING;
        }
        return new AnyOfMatcher(characters);
    }

    @DontLabel
    public Rule String(String string) {
        Preconditions.checkArgNotNull((Object)string, (String)"string");
        return this.String(string.toCharArray());
    }

    @Cached
    @SuppressSubnodes
    @DontLabel
    public Rule String(char ... characters) {
        if (characters.length == 1) {
            return this.Ch(characters[0]);
        }
        Rule[] matchers = new Rule[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            matchers[i] = this.Ch(characters[i]);
        }
        return new StringMatcher(matchers, characters);
    }

    @DontLabel
    public Rule IgnoreCase(String string) {
        Preconditions.checkArgNotNull((Object)string, (String)"string");
        return this.IgnoreCase(string.toCharArray());
    }

    @Cached
    @SuppressSubnodes
    @DontLabel
    public Rule IgnoreCase(char ... characters) {
        if (characters.length == 1) {
            return this.IgnoreCase(characters[0]);
        }
        Object[] matchers = new Rule[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            matchers[i] = this.IgnoreCase(characters[i]);
        }
        return ((SequenceMatcher)this.Sequence(matchers)).label('\"' + String.valueOf(characters) + '\"');
    }

    @DontLabel
    public Rule FirstOf(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull((Object)moreRules, (String)"moreRules");
        return this.FirstOf(Utils.arrayOf((Object)rule, (Object)rule2, (Object[])moreRules));
    }

    @Cached
    @DontLabel
    public Rule FirstOf(Object[] rules) {
        Preconditions.checkArgNotNull((Object)rules, (String)"rules");
        if (rules.length == 1) {
            return this.toRule(rules[0]);
        }
        Rule[] convertedRules = this.toRules(rules);
        char[][] chars = new char[rules.length][];
        int convertedRulesLength = convertedRules.length;
        for (int i = 0; i < convertedRulesLength; ++i) {
            Rule rule = convertedRules[i];
            if (!(rule instanceof StringMatcher)) {
                return new FirstOfMatcher(convertedRules);
            }
            chars[i] = ((StringMatcher)rule).characters;
        }
        return new FirstOfStringsMatcher(convertedRules, (char[][])chars);
    }

    @Cached
    @DontLabel
    public Rule OneOrMore(Object rule) {
        return new OneOrMoreMatcher(this.toRule(rule));
    }

    @DontLabel
    public Rule OneOrMore(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull((Object)moreRules, (String)"moreRules");
        return this.OneOrMore(this.Sequence(rule, rule2, moreRules));
    }

    @Cached
    @DontLabel
    public Rule Optional(Object rule) {
        return new OptionalMatcher(this.toRule(rule));
    }

    @DontLabel
    public Rule Optional(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull((Object)moreRules, (String)"moreRules");
        return this.Optional(this.Sequence(rule, rule2, moreRules));
    }

    @DontLabel
    public Rule Sequence(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull((Object)moreRules, (String)"moreRules");
        return this.Sequence(Utils.arrayOf((Object)rule, (Object)rule2, (Object[])moreRules));
    }

    @Cached
    @DontLabel
    public Rule Sequence(Object[] rules) {
        Preconditions.checkArgNotNull((Object)rules, (String)"rules");
        return rules.length == 1 ? this.toRule(rules[0]) : new SequenceMatcher(this.toRules(rules));
    }

    @Cached
    @SuppressNode
    @DontLabel
    public Rule Test(Object rule) {
        Rule subMatcher = this.toRule(rule);
        return new TestMatcher(subMatcher);
    }

    @DontLabel
    public Rule Test(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull((Object)moreRules, (String)"moreRules");
        return this.Test(this.Sequence(rule, rule2, moreRules));
    }

    @Cached
    @SuppressNode
    @DontLabel
    public Rule TestNot(Object rule) {
        Rule subMatcher = this.toRule(rule);
        return new TestNotMatcher(subMatcher);
    }

    @DontLabel
    public Rule TestNot(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull((Object)moreRules, (String)"moreRules");
        return this.TestNot(this.Sequence(rule, rule2, moreRules));
    }

    @Cached
    @DontLabel
    public Rule ZeroOrMore(Object rule) {
        return new ZeroOrMoreMatcher(this.toRule(rule));
    }

    @DontLabel
    public Rule ZeroOrMore(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull((Object)moreRules, (String)"moreRules");
        return this.ZeroOrMore(this.Sequence(rule, rule2, moreRules));
    }

    public static Action ACTION(boolean expression) {
        throw new UnsupportedOperationException("ACTION(...) calls can only be used in Rule creating parser methods");
    }

    @DontExtend
    protected Rule fromCharLiteral(char c) {
        return this.Ch(c);
    }

    @DontExtend
    protected Rule fromStringLiteral(String string) {
        Preconditions.checkArgNotNull((Object)string, (String)"string");
        return this.fromCharArray(string.toCharArray());
    }

    @DontExtend
    protected Rule fromCharArray(char[] array) {
        Preconditions.checkArgNotNull((Object)array, (String)"array");
        return this.String(array);
    }

    @DontExtend
    public Rule[] toRules(Object ... objects) {
        Preconditions.checkArgNotNull((Object)objects, (String)"objects");
        Rule[] rules = new Rule[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            rules[i] = this.toRule(objects[i]);
        }
        return rules;
    }

    @DontExtend
    public Rule toRule(Object obj) {
        if (obj instanceof Rule) {
            return (Rule)obj;
        }
        if (obj instanceof Character) {
            return this.fromCharLiteral(((Character)obj).charValue());
        }
        if (obj instanceof String) {
            return this.fromStringLiteral((String)obj);
        }
        if (obj instanceof char[]) {
            return this.fromCharArray((char[])obj);
        }
        if (obj instanceof Action) {
            Action action = (Action)obj;
            return new ActionMatcher(action);
        }
        Checks.ensure((!(obj instanceof Boolean) ? 1 : 0) != 0, (String)"Rule specification contains an unwrapped Boolean value, if you were trying to specify a parser action wrap the expression with ACTION(...)");
        throw new GrammarException("'" + obj + "' cannot be automatically converted to a parser Rule");
    }
}

