/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;

class SuperCallRewriter
implements RuleMethodProcessor {
    SuperCallRewriter() {
    }

    public boolean appliesTo(ParserClassNode classNode, RuleMethod method) {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        return method.containsPotentialSuperCalls();
    }

    public void process(ParserClassNode classNode, RuleMethod method) throws Exception {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        InsnList instructions = method.instructions;
        AbstractInsnNode insn = instructions.getFirst();
        while (insn.getOpcode() != 176) {
            if (insn.getOpcode() == 183) {
                this.process(classNode, method, (MethodInsnNode)insn);
            }
            insn = insn.getNext();
        }
    }

    private void process(ParserClassNode classNode, RuleMethod method, MethodInsnNode insn) {
        if ("<init>".equals(insn.name)) {
            return;
        }
        String superMethodName = this.getSuperMethodName(method, insn);
        RuleMethod superMethod = classNode.getRuleMethods().get(superMethodName.concat(insn.desc));
        if (superMethod == null) {
            return;
        }
        if (!superMethod.isBodyRewritten()) {
            return;
        }
        superMethod.dontSkipGeneration();
        insn.setOpcode(182);
        insn.name = superMethodName;
        insn.owner = classNode.name;
        method.setBodyRewritten();
    }

    private String getSuperMethodName(RuleMethod method, MethodInsnNode insn) {
        Class<?> clazz = method.getOwnerClass();
        String superMethodName = method.name;
        do {
            Preconditions.checkState(((clazz = clazz.getSuperclass()) != null ? 1 : 0) != 0);
            superMethodName = '$' + superMethodName;
        } while (!Type.getInternalName(clazz).equals(insn.owner));
        return superMethodName;
    }
}

