/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.BsdLoopbackPacket;
import org.pcap4j.packet.IcmpV4CommonPacket;
import org.pcap4j.packet.IcmpV4EchoPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.packet.namednumber.IcmpV4Code;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.ProtocolFamily;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsdLoopbackPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(BsdLoopbackPacketTest.class);
    private final BsdLoopbackPacket packet;
    private final ProtocolFamily protocolFamily = ProtocolFamily.PF_INET;

    public BsdLoopbackPacketTest() throws UnknownHostException {
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder().rawData(new byte[]{0, 1, 2, 3});
        IcmpV4EchoPacket.Builder echob = new IcmpV4EchoPacket.Builder().identifier((short)1234).sequenceNumber((short)4321).payloadBuilder((Packet.Builder)unknownb);
        IcmpV4CommonPacket.Builder icmpV4b = new IcmpV4CommonPacket.Builder().type(IcmpV4Type.ECHO).code(IcmpV4Code.NO_CODE).payloadBuilder((Packet.Builder)echob).correctChecksumAtBuild(true);
        IpV4Packet.Builder ipv4b = new IpV4Packet.Builder().version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc1349Tos.newInstance((byte)0)).identification((short)100).ttl((byte)100).protocol(IpNumber.ICMPV4).srcAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).dstAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 2})).payloadBuilder((Packet.Builder)icmpV4b).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        BsdLoopbackPacket.Builder eb = new BsdLoopbackPacket.Builder().protocolFamily(this.protocolFamily).payloadBuilder((Packet.Builder)ipv4b);
        this.packet = eb.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        return this.packet;
    }

    @Override
    protected DataLinkType getDataLinkType() {
        return DataLinkType.NULL;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + BsdLoopbackPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            BsdLoopbackPacket p = BsdLoopbackPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        BsdLoopbackPacket.BsdLoopbackHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.protocolFamily, (Object)h.getProtocolFamily());
    }
}

