/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.Dot112040BssCoexistenceElement;
import org.pcap4j.packet.Dot11AbstractSupportedRatesElement;
import org.pcap4j.packet.Dot11ChannelEntry;
import org.pcap4j.packet.Dot11ChannelUsageElement;
import org.pcap4j.packet.Dot11DsssParameterSetElement;
import org.pcap4j.packet.Dot11ExtendedCapabilitiesElement;
import org.pcap4j.packet.Dot11ExtendedSupportedRatesElement;
import org.pcap4j.packet.Dot11FrameControl;
import org.pcap4j.packet.Dot11HTCapabilitiesElement;
import org.pcap4j.packet.Dot11HtControl;
import org.pcap4j.packet.Dot11InterworkingElement;
import org.pcap4j.packet.Dot11LinkAdaptationControl;
import org.pcap4j.packet.Dot11MeshIdElement;
import org.pcap4j.packet.Dot11ProbeRequestPacket;
import org.pcap4j.packet.Dot11RequestElement;
import org.pcap4j.packet.Dot11SequenceControl;
import org.pcap4j.packet.Dot11SsidElement;
import org.pcap4j.packet.Dot11SsidListElement;
import org.pcap4j.packet.Dot11SupportedOperatingClassesElement;
import org.pcap4j.packet.Dot11SupportedRatesElement;
import org.pcap4j.packet.Dot11VendorSpecificElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.packet.namednumber.Dot11AccessNetworkType;
import org.pcap4j.packet.namednumber.Dot11BssMembershipSelector;
import org.pcap4j.packet.namednumber.Dot11ChannelUsageMode;
import org.pcap4j.packet.namednumber.Dot11FrameType;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.packet.namednumber.Dot11ServiceIntervalGranularity;
import org.pcap4j.packet.namednumber.Dot11VenueInfo;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dot11ProbeRequestPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(Dot11ProbeRequestPacketTest.class);
    private final Dot11FrameControl frameControl = new Dot11FrameControl.Builder().protocolVersion(Dot11FrameControl.ProtocolVersion.V0).type(Dot11FrameType.PROBE_REQUEST).toDs(true).fromDs(false).moreFragments(false).retry(true).powerManagement(false).moreData(false).protectedFrame(false).order(true).build();
    private final short duration = (short)1234;
    private final MacAddress address1 = MacAddress.getByName((String)"aa:bb:cc:dd:ee:ff");
    private final MacAddress address2 = MacAddress.getByName((String)"ff:aa:ff:aa:ff:aa");
    private final MacAddress address3 = MacAddress.getByName((String)"11:22:33:44:55:66");
    private final Dot11SequenceControl sequenceControl = new Dot11SequenceControl.Builder().fragmentNumber((byte)10).sequenceNumber((short)2748).build();
    private final Dot11HtControl htControl = new Dot11HtControl.Builder().linkAdaptationControl(new Dot11LinkAdaptationControl.Builder().vhtMfb(false).trq(true).maiOrAseli(new Dot11LinkAdaptationControl.Mai(true, 2)).mfsi((byte)3).mfbOrAselc((byte)123).build()).calibrationPosition(Dot11HtControl.CalibrationPosition.SOUNDING_COMPLETE).calibrationSequence((byte)3).bit20(true).bit21(false).csiOrSteering(Dot11HtControl.CsiOrSteering.NONCOMPRESSED_BEAMFORMING).ndpAnnouncement(false).bit25(true).bit26(false).bit27(false).bit28(true).bit29(true).acConstraint(true).rdgOrMorePpdu(false).build();
    private final Dot11SsidElement ssid = new Dot11SsidElement.Builder().correctLengthAtBuild(true).ssid("hogehoge").build();
    private final Dot11SupportedRatesElement supportedRates;
    private final Dot11RequestElement request;
    private final Dot11ExtendedSupportedRatesElement extendedSupportedRates;
    private final Dot11DsssParameterSetElement dsssParameterSet;
    private final Dot11SupportedOperatingClassesElement supportedOperatingClasses;
    private final Dot11HTCapabilitiesElement htCapabilities;
    private final Dot112040BssCoexistenceElement twentyFortyBssCoexistence;
    private final Dot11ExtendedCapabilitiesElement extendedCapabilities;
    private final Dot11SsidListElement ssidList;
    private final Dot11ChannelUsageElement channelUsage;
    private final Dot11InterworkingElement interworking;
    private final Dot11MeshIdElement meshId;
    private final List<Dot11VendorSpecificElement> vendorSpecificElements;
    private final Dot11ProbeRequestPacket packet;

    public Dot11ProbeRequestPacketTest() throws Exception {
        ArrayList<Object> ratesAndBssMembershipSelectors = new ArrayList<Object>();
        ratesAndBssMembershipSelectors.add(new Dot11AbstractSupportedRatesElement.Rate(true, 16));
        ratesAndBssMembershipSelectors.add(new Dot11AbstractSupportedRatesElement.BssMembershipSelector(true, Dot11BssMembershipSelector.HT_PHY));
        ratesAndBssMembershipSelectors.add(new Dot11AbstractSupportedRatesElement.Rate(true, 32));
        ratesAndBssMembershipSelectors.add(new Dot11AbstractSupportedRatesElement.BssMembershipSelector(false, Dot11BssMembershipSelector.HT_PHY));
        ratesAndBssMembershipSelectors.add(new Dot11AbstractSupportedRatesElement.Rate(false, 48));
        this.supportedRates = new Dot11SupportedRatesElement.Builder().correctLengthAtBuild(true).ratesAndBssMembershipSelectors(ratesAndBssMembershipSelectors).build();
        ArrayList<Dot11InformationElementId> requestedElementIds = new ArrayList<Dot11InformationElementId>();
        requestedElementIds.add(Dot11InformationElementId.ADVERTISEMENT_PROTOCOL);
        requestedElementIds.add(Dot11InformationElementId.BSS_AC_ACCESS_DELAY);
        requestedElementIds.add(Dot11InformationElementId.EMERGENCY_ALERT_IDENTIFIER);
        this.request = new Dot11RequestElement.Builder().correctLengthAtBuild(true).requestedElementIds(requestedElementIds).build();
        ratesAndBssMembershipSelectors.clear();
        ratesAndBssMembershipSelectors.add(new Dot11AbstractSupportedRatesElement.BssMembershipSelector(false, Dot11BssMembershipSelector.HT_PHY));
        ratesAndBssMembershipSelectors.add(new Dot11AbstractSupportedRatesElement.Rate(true, 111));
        this.extendedSupportedRates = new Dot11ExtendedSupportedRatesElement.Builder().correctLengthAtBuild(true).ratesAndBssMembershipSelectors(ratesAndBssMembershipSelectors).build();
        this.dsssParameterSet = new Dot11DsssParameterSetElement.Builder().correctLengthAtBuild(true).currentChannel((byte)-103).build();
        this.supportedOperatingClasses = new Dot11SupportedOperatingClassesElement.Builder().correctLengthAtBuild(true).currentOperatingClass((byte)-18).operatingClasses(new byte[]{5, 4, 3, 2, 1}).build();
        this.htCapabilities = new Dot11HTCapabilitiesElement.Builder().correctLengthAtBuild(true).ldpcCodingSupported(false).both20and40MhzSupported(true).smPowerSaveMode(Dot11HTCapabilitiesElement.SmPowerSaveMode.DYNAMIC).htGreenfieldSupported(false).shortGiFor20MhzSupported(true).shortGiFor40MhzSupported(false).txStbcSupported(true).rxStbcSupport(Dot11HTCapabilitiesElement.StbcSupport.ONE_SPATIAL_STREAM).htDelayedBlockAckSupported(false).maxAMsduLength(Dot11HTCapabilitiesElement.AMsduLength.MAX_7935).dsssCckModeIn40MhzSupported(true).bit13OfHtCapabilitiesInfo(false).fortyMhzIntolerant(true).lSigTxopProtectionSupported(false).maxAMpduLength(Dot11HTCapabilitiesElement.AMpduLength.MAX_32767).minMpduStartSpacing(Dot11HTCapabilitiesElement.MpduStartSpacing.FOUR_US).bit5OfAMpduParameters(true).bit6OfAMpduParameters(false).bit7OfAMpduParameters(true).supportedRxMcsIndexes(new boolean[]{true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false}).bit77OfSupportedMcsSet(false).bit78OfSupportedMcsSet(false).bit79OfSupportedMcsSet(true).rxHighestSupportedDataRate((short)1000).bit90OfSupportedMcsSet(false).bit91OfSupportedMcsSet(false).bit92OfSupportedMcsSet(true).bit93OfSupportedMcsSet(false).bit94OfSupportedMcsSet(false).bit95OfSupportedMcsSet(true).txMcsSetDefined(false).txRxMcsSetNotEqual(false).txMaxNumSpatialStreamsSupported(Dot11HTCapabilitiesElement.NumSpatialStreams.THREE).txUnequalModulationSupported(true).bit101OfSupportedMcsSet(false).bit102OfSupportedMcsSet(false).bit103OfSupportedMcsSet(true).bit104OfSupportedMcsSet(false).bit105OfSupportedMcsSet(false).bit106OfSupportedMcsSet(true).bit107OfSupportedMcsSet(false).bit108OfSupportedMcsSet(false).bit109OfSupportedMcsSet(true).bit110OfSupportedMcsSet(false).bit111OfSupportedMcsSet(false).bit112OfSupportedMcsSet(true).bit113OfSupportedMcsSet(false).bit114OfSupportedMcsSet(false).bit115OfSupportedMcsSet(true).bit116OfSupportedMcsSet(false).bit117OfSupportedMcsSet(false).bit118OfSupportedMcsSet(true).bit119OfSupportedMcsSet(false).bit120OfSupportedMcsSet(false).bit121OfSupportedMcsSet(true).bit122OfSupportedMcsSet(false).bit123OfSupportedMcsSet(false).bit124OfSupportedMcsSet(true).bit125OfSupportedMcsSet(false).bit126OfSupportedMcsSet(false).bit127OfSupportedMcsSet(true).pcoSupported(false).pcoTransitionTime(Dot11HTCapabilitiesElement.PcoTransitionTime.PTT_1_5_MS).bit3OfHtExtendedCapabilities(false).bit4OfHtExtendedCapabilities(true).bit5OfHtExtendedCapabilities(false).bit6OfHtExtendedCapabilities(false).bit7OfHtExtendedCapabilities(true).mcsFeedbackCapability(Dot11HTCapabilitiesElement.McsFeedbackCapability.ONLY_UNSOLICITED).htControlFieldSupported(false).rdResponderSupported(false).bit12OfHtExtendedCapabilities(true).bit13OfHtExtendedCapabilities(false).bit14OfHtExtendedCapabilities(false).bit15OfHtExtendedCapabilities(true).implicitTxBeamformingReceivingSupported(false).rxStaggeredSoundingSupported(false).txStaggeredSoundingSupported(true).rxNdpSupported(false).txNdpSupported(false).implicitTxBeamformingSupported(true).calibration(Dot11HTCapabilitiesElement.Calibration.RESPOND).explicitCsiTxBeamformingSupported(false).explicitNoncompressedSteeringSupported(false).explicitCompressedSteeringSupported(true).explicitTxBeamformingCsiFeedbackCapability(Dot11HTCapabilitiesElement.BeamformingFeedbackCapability.DELAYED).explicitNoncompressedBeamformingFeedbackCapability(Dot11HTCapabilitiesElement.BeamformingFeedbackCapability.DELAYED_AND_IMMEDIATE).explicitCompressedBeamformingFeedbackCapability(Dot11HTCapabilitiesElement.BeamformingFeedbackCapability.IMMEDIATE).minGrouping(Dot11HTCapabilitiesElement.Grouping.GROUPS_OF_1_2).csiNumBeamformerAntennasSupported(Dot11HTCapabilitiesElement.NumBeamformerAntennas.TWO).noncompressedSteeringNumBeamformerAntennasSupported(Dot11HTCapabilitiesElement.NumBeamformerAntennas.FOUR).compressedSteeringNumBeamformerAntennasSupported(Dot11HTCapabilitiesElement.NumBeamformerAntennas.SINGLE).csiMaxNumRowsBeamformerSupported(Dot11HTCapabilitiesElement.CsiNumRows.THREE).channelEstimationCapability(Dot11HTCapabilitiesElement.ChannelEstimationCapability.TWO_SPACE_TIME_STREAMS).bit29OfTransmitBeamformingCapabilities(false).bit30OfTransmitBeamformingCapabilities(false).bit31OfTransmitBeamformingCapabilities(true).antennaSelectionSupported(false).explicitCsiFeedbackBasedTxAselSupported(false).antennaIndicesFeedbackBasedTxAselSupported(true).explicitCsiFeedbackSupported(false).antennaIndicesFeedbackSupported(false).rxAselSupported(true).txSoundingPpdusSupported(false).bit7OfAselCapability(false).build();
        this.twentyFortyBssCoexistence = new Dot112040BssCoexistenceElement.Builder().correctLengthAtBuild(true).informationRequested(false).fortyMhzIntolerant(false).twentyMhzBssWidthRequested(true).obssScanningExemptionRequested(false).obssScanningExemptionGranted(false).bit5(true).bit6(true).bit7(true).build();
        this.extendedCapabilities = new Dot11ExtendedCapabilitiesElement.Builder().correctLengthAtBuild(true).twentyFortyBssCoexistenceManagementSupported(Boolean.valueOf(false)).bit1(Boolean.valueOf(false)).extendedChannelSwitchingSupported(Boolean.valueOf(true)).bit3(Boolean.valueOf(false)).psmpOperationSupported(Boolean.valueOf(false)).bit5(Boolean.valueOf(true)).scheduledPsmpSupported(Boolean.valueOf(false)).eventActivated(Boolean.valueOf(false)).diagnosticsActivated(Boolean.valueOf(true)).multicastDiagnosticsActivated(Boolean.valueOf(false)).locationTrackingActivated(Boolean.valueOf(false)).fmsActivated(Boolean.valueOf(true)).proxyArpServiceActivated(Boolean.valueOf(false)).collocatedInterferenceReportingActivated(Boolean.valueOf(false)).rmCivicMeasurementActivated(Boolean.valueOf(true)).rmLciMeasurementActivated(Boolean.valueOf(false)).tfsActivated(Boolean.valueOf(false)).wnmSleepModeActivated(Boolean.valueOf(true)).timBroadcastActivated(Boolean.valueOf(false)).bssTransitionActivated(Boolean.valueOf(false)).qosTrafficCapabilityActivated(Boolean.valueOf(true)).acStationCountActivated(Boolean.valueOf(false)).multiBssIdActivated(Boolean.valueOf(false)).timingMeasurementActivated(Boolean.valueOf(true)).channelUsageActivated(Boolean.valueOf(false)).ssidListActivated(Boolean.valueOf(false)).dmsActivated(Boolean.valueOf(true)).utcTsfOffsetActivated(Boolean.valueOf(false)).tdlsPeerUapsdBufferStaSupported(Boolean.valueOf(false)).tdlsPeerPsmSupported(Boolean.valueOf(true)).tdlsChannelSwitchingActivated(Boolean.valueOf(false)).interworkingServiceActivated(Boolean.valueOf(false)).qosMapActivated(Boolean.valueOf(true)).ebrActivated(Boolean.valueOf(false)).sspnInterfaceActivated(Boolean.valueOf(false)).bit35(Boolean.valueOf(true)).msgcfActivated(Boolean.valueOf(false)).tdlsSupported(Boolean.valueOf(false)).tdlsProhibited(Boolean.valueOf(true)).tdlsChannelSwitchingProhibited(Boolean.valueOf(false)).rejectingUnadmittedTraffic(Boolean.valueOf(false)).serviceIntervalGranularity(Dot11ServiceIntervalGranularity.SIG_35_MS).rmIdentifierMeasurementActivated(Boolean.valueOf(false)).uapsdCoexistenceActivated(Boolean.valueOf(false)).wnmNotificationActivated(Boolean.valueOf(true)).bit47(Boolean.valueOf(false)).utf8Ssid(Boolean.valueOf(false)).bit49(Boolean.valueOf(true)).bit50(Boolean.valueOf(false)).bit51(Boolean.valueOf(false)).bit52(Boolean.valueOf(true)).bit53(Boolean.valueOf(false)).bit54(Boolean.valueOf(false)).bit55(Boolean.valueOf(true)).trailingData(new byte[]{18, 52}).build();
        ArrayList<Dot11SsidElement> ssids = new ArrayList<Dot11SsidElement>();
        ssids.add(new Dot11SsidElement.Builder().correctLengthAtBuild(true).ssid("abcde").build());
        ssids.add(new Dot11SsidElement.Builder().correctLengthAtBuild(true).ssid("fooooooooooooooooo").build());
        this.ssidList = new Dot11SsidListElement.Builder().correctLengthAtBuild(true).ssidList(ssids).build();
        ArrayList<Dot11ChannelEntry> channelEntries = new ArrayList<Dot11ChannelEntry>();
        channelEntries.add(new Dot11ChannelEntry(1, 16));
        channelEntries.add(new Dot11ChannelEntry(2, 32));
        channelEntries.add(new Dot11ChannelEntry(3, 48));
        this.channelUsage = new Dot11ChannelUsageElement.Builder().correctLengthAtBuild(true).usageMode(Dot11ChannelUsageMode.NONINFRASTRUCTURE_DOT_11).channelEntries(channelEntries).build();
        this.interworking = new Dot11InterworkingElement.Builder().correctLengthAtBuild(true).accessnetworkType(Dot11AccessNetworkType.PRIVATE_NETWORK).internet(false).asra(true).esr(false).uesa(true).venueInfo(Dot11VenueInfo.POLICE_STATION).hessid(new byte[]{10, 11, 12, 13, 14, 15}).build();
        this.meshId = new Dot11MeshIdElement.Builder().correctLengthAtBuild(true).meshId(new byte[]{80, 64, 48, 32, 16, 0}).build();
        this.vendorSpecificElements = new ArrayList<Dot11VendorSpecificElement>();
        this.vendorSpecificElements.add(new Dot11VendorSpecificElement.Builder().information(new byte[]{1, 1, 1, 1, 1}).correctLengthAtBuild(true).build());
        this.vendorSpecificElements.add(new Dot11VendorSpecificElement.Builder().information(new byte[]{2, 2, 2, 2, 2, 2}).correctLengthAtBuild(true).build());
        Dot11ProbeRequestPacket.Builder b = new Dot11ProbeRequestPacket.Builder().frameControl(this.frameControl).duration(this.duration).address1(this.address1).address2(this.address2).address3(this.address3).sequenceControl(this.sequenceControl).htControl(this.htControl).ssid(this.ssid).supportedRates(this.supportedRates).request(this.request).extendedSupportedRates(this.extendedSupportedRates).dsssParameterSet(this.dsssParameterSet).supportedOperatingClasses(this.supportedOperatingClasses).htCapabilities(this.htCapabilities).twentyFortyBssCoexistence(this.twentyFortyBssCoexistence).extendedCapabilities(this.extendedCapabilities).ssidList(this.ssidList).channelUsage(this.channelUsage).interworking(this.interworking).meshId(this.meshId).vendorSpecificElements(this.vendorSpecificElements);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        return this.packet;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + Dot11ProbeRequestPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            Dot11ProbeRequestPacket p = Dot11ProbeRequestPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        Dot11ProbeRequestPacket.Dot11ProbeRequestHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.frameControl, (Object)h.getFrameControl());
        Assert.assertEquals((long)this.duration, (long)h.getDuration());
        Assert.assertEquals((Object)this.address1, (Object)h.getAddress1());
        Assert.assertEquals((Object)this.address2, (Object)h.getAddress2());
        Assert.assertEquals((Object)this.address3, (Object)h.getAddress3());
        Assert.assertEquals((Object)this.sequenceControl, (Object)h.getSequenceControl());
        Assert.assertEquals((Object)this.htControl, (Object)h.getHtControl());
        Assert.assertEquals((Object)this.ssid, (Object)h.getSsid());
        Assert.assertEquals((Object)this.supportedRates, (Object)h.getSupportedRates());
        Assert.assertEquals((Object)this.request, (Object)h.getRequest());
        Assert.assertEquals((Object)this.extendedSupportedRates, (Object)h.getExtendedSupportedRates());
        Assert.assertEquals((Object)this.dsssParameterSet, (Object)h.getDsssParameterSet());
        Assert.assertEquals((Object)this.supportedOperatingClasses, (Object)h.getSupportedOperatingClasses());
        Assert.assertEquals((Object)this.htCapabilities, (Object)h.getHtCapabilities());
        Assert.assertEquals((Object)this.twentyFortyBssCoexistence, (Object)h.get2040BssCoexistence());
        Assert.assertEquals((Object)this.extendedCapabilities, (Object)h.getExtendedCapabilities());
        Assert.assertEquals((Object)this.ssidList, (Object)h.getSsidList());
        Assert.assertEquals((Object)this.channelUsage, (Object)h.getChannelUsage());
        Assert.assertEquals((Object)this.interworking, (Object)h.getInterworking());
        Assert.assertEquals((Object)this.meshId, (Object)h.getMeshId());
        Assert.assertEquals(this.vendorSpecificElements, (Object)h.getVendorSpecificElements());
    }

    @Override
    protected DataLinkType getDataLinkType() {
        return DataLinkType.IEEE802_11;
    }

    @Test
    public void testHasValidFcs() {
        Assert.assertFalse((boolean)this.packet.hasValidFcs());
        Dot11ProbeRequestPacket.Builder b = this.packet.getBuilder().fcs(Integer.valueOf(111)).correctChecksumAtBuild(false);
        Dot11ProbeRequestPacket p = b.correctChecksumAtBuild(false).build();
        Assert.assertFalse((boolean)p.hasValidFcs());
        b.correctChecksumAtBuild(true);
        p = b.build();
        Assert.assertTrue((boolean)p.hasValidFcs());
    }
}

