/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IcmpV4CommonPacket;
import org.pcap4j.packet.IcmpV4InformationRequestPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IcmpV4Code;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpV4InformationRequestPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IcmpV4InformationRequestPacketTest.class);
    private final IcmpV4InformationRequestPacket packet;
    private final short identifier = (short)1234;
    private final short sequenceNumber = (short)4321;

    public IcmpV4InformationRequestPacketTest() {
        IcmpV4InformationRequestPacket.Builder b = new IcmpV4InformationRequestPacket.Builder();
        b.identifier(this.identifier).sequenceNumber(this.sequenceNumber);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() throws UnknownHostException {
        IcmpV4CommonPacket.Builder icmpV4b = new IcmpV4CommonPacket.Builder();
        icmpV4b.type(IcmpV4Type.INFORMATION_REQUEST).code(IcmpV4Code.NO_CODE).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)this.packet)).correctChecksumAtBuild(true);
        IpV4Packet.Builder ipv4b = new IpV4Packet.Builder();
        ipv4b.version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc1349Tos.newInstance((byte)0)).identification((short)100).ttl((byte)100).protocol(IpNumber.ICMPV4).srcAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).dstAddr((Inet4Address)InetAddress.getByAddress(new byte[]{0, 0, 0, 0})).payloadBuilder((Packet.Builder)icmpV4b).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.ETHER_BROADCAST_ADDRESS).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV4).payloadBuilder((Packet.Builder)ipv4b).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IcmpV4InformationRequestPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            IcmpV4InformationRequestPacket p = IcmpV4InformationRequestPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        IcmpV4InformationRequestPacket.IcmpV4InformationRequestHeader h = this.packet.getHeader();
        Assert.assertEquals((long)this.identifier, (long)h.getIdentifier());
        Assert.assertEquals((long)this.sequenceNumber, (long)h.getSequenceNumber());
        IcmpV4InformationRequestPacket.Builder b = this.packet.getBuilder();
        b.identifier((short)0);
        b.sequenceNumber((short)0);
        IcmpV4InformationRequestPacket p = b.build();
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getIdentifierAsInt()));
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getSequenceNumberAsInt()));
        b.identifier((short)10000);
        b.sequenceNumber((short)10000);
        p = b.build();
        Assert.assertEquals((long)10000L, (long)((short)p.getHeader().getIdentifierAsInt()));
        Assert.assertEquals((long)10000L, (long)((short)p.getHeader().getSequenceNumberAsInt()));
        b.identifier((short)Short.MAX_VALUE);
        b.sequenceNumber((short)Short.MAX_VALUE);
        p = b.build();
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getIdentifierAsInt()));
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getSequenceNumberAsInt()));
        b.identifier((short)-1);
        b.sequenceNumber((short)-1);
        p = b.build();
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getIdentifierAsInt()));
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getSequenceNumberAsInt()));
        b.identifier((short)Short.MIN_VALUE);
        b.sequenceNumber((short)Short.MIN_VALUE);
        p = b.build();
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getIdentifierAsInt()));
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getSequenceNumberAsInt()));
    }
}

