/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IcmpV4CommonPacket;
import org.pcap4j.packet.IcmpV4EchoPacket;
import org.pcap4j.packet.IcmpV4ParameterProblemPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IcmpV4Code;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.util.IcmpV4Helper;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpV4ParameterProblemPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IcmpV4ParameterProblemPacketTest.class);
    private final IcmpV4ParameterProblemPacket packet;
    private final byte pointer = (byte)123;
    private final int unused;

    public IcmpV4ParameterProblemPacketTest() {
        this.unused = 321;
        IcmpV4EchoPacket.Builder echob = new IcmpV4EchoPacket.Builder();
        echob.identifier((short)100).sequenceNumber((short)10).payloadBuilder((Packet.Builder)new UnknownPacket.Builder().rawData(new byte[]{0, 1, 2}));
        IcmpV4CommonPacket.Builder icmpV4b = new IcmpV4CommonPacket.Builder();
        icmpV4b.type(IcmpV4Type.ECHO).code(IcmpV4Code.NO_CODE).payloadBuilder((Packet.Builder)echob).correctChecksumAtBuild(true);
        IpV4Packet.Builder ipv4b = new IpV4Packet.Builder();
        try {
            ipv4b.version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc1349Tos.newInstance((byte)0)).identification((short)100).ttl((byte)100).protocol(IpNumber.ICMPV4).srcAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 2})).dstAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).payloadBuilder((Packet.Builder)icmpV4b).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        IcmpV4ParameterProblemPacket.Builder b = new IcmpV4ParameterProblemPacket.Builder();
        b.pointer(this.pointer).unused(this.unused).payload(IcmpV4Helper.makePacketForInvokingPacketField((Packet)ipv4b.build()));
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() throws UnknownHostException {
        IcmpV4CommonPacket.Builder icmpV4b = new IcmpV4CommonPacket.Builder();
        icmpV4b.type(IcmpV4Type.PARAMETER_PROBLEM).code(IcmpV4Code.POINTER_INDICATES_ERROR).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)this.packet)).correctChecksumAtBuild(true);
        IpV4Packet.Builder ipv4b = new IpV4Packet.Builder();
        ipv4b.version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc1349Tos.newInstance((byte)0)).identification((short)100).ttl((byte)100).protocol(IpNumber.ICMPV4).srcAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).dstAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 2})).payloadBuilder((Packet.Builder)icmpV4b).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV4).payloadBuilder((Packet.Builder)ipv4b).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IcmpV4ParameterProblemPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        IcmpV4ParameterProblemPacket p;
        try {
            p = IcmpV4ParameterProblemPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
        Assert.assertEquals((Object)this.packet, (Object)p);
        Assert.assertTrue((boolean)p.getPayload().contains(IpV4Packet.class));
        Assert.assertTrue((boolean)p.getPayload().contains(IcmpV4CommonPacket.class));
        Assert.assertTrue((boolean)p.getPayload().contains(IcmpV4EchoPacket.class));
        Assert.assertFalse((boolean)p.getPayload().contains(UnknownPacket.class));
        Assert.assertFalse((boolean)p.getPayload().contains(IllegalPacket.class));
    }

    @Test
    public void testGetHeader() {
        IcmpV4ParameterProblemPacket.IcmpV4ParameterProblemHeader h = this.packet.getHeader();
        Assert.assertEquals((long)this.pointer, (long)h.getPointer());
        Assert.assertEquals((long)this.unused, (long)h.getUnused());
        IcmpV4ParameterProblemPacket.Builder b = this.packet.getBuilder();
        b.pointer((byte)0);
        IcmpV4ParameterProblemPacket p = b.build();
        Assert.assertEquals((long)0L, (long)((byte)p.getHeader().getPointerAsInt()));
        b.pointer((byte)50);
        p = b.build();
        Assert.assertEquals((long)50L, (long)((byte)p.getHeader().getPointerAsInt()));
        b.pointer((byte)127);
        p = b.build();
        Assert.assertEquals((long)127L, (long)((byte)p.getHeader().getPointerAsInt()));
        b.pointer((byte)-1);
        p = b.build();
        Assert.assertEquals((long)-1L, (long)((byte)p.getHeader().getPointerAsInt()));
        b.pointer((byte)-128);
        p = b.build();
        Assert.assertEquals((long)-128L, (long)((byte)p.getHeader().getPointerAsInt()));
        b.unused(0);
        p = b.build();
        Assert.assertEquals((long)0L, (long)p.getHeader().getUnused());
        b.unused(1000000);
        p = b.build();
        Assert.assertEquals((long)1000000L, (long)p.getHeader().getUnused());
        b.unused(0xFFFFFF);
        p = b.build();
        Assert.assertEquals((long)0xFFFFFFL, (long)p.getHeader().getUnused());
        b.unused(0x1000000);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        b.unused(-1);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }
}

