/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IcmpV6EchoRequestPacket;
import org.pcap4j.packet.IcmpV6ParameterProblemPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IcmpV6Code;
import org.pcap4j.packet.namednumber.IcmpV6Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpV6ParameterProblemPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IcmpV6ParameterProblemPacketTest.class);
    private final IcmpV6ParameterProblemPacket packet;
    private final int pointer;

    public IcmpV6ParameterProblemPacketTest() {
        Inet6Address dstAddr;
        Inet6Address srcAddr;
        this.pointer = 12345;
        IcmpV6EchoRequestPacket.Builder echob = new IcmpV6EchoRequestPacket.Builder();
        echob.identifier((short)100).sequenceNumber((short)10).payloadBuilder((Packet.Builder)new UnknownPacket.Builder().rawData(new byte[]{0, 1, 2}));
        try {
            srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
            dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        IcmpV6CommonPacket.Builder icmpV6b = new IcmpV6CommonPacket.Builder();
        icmpV6b.type(IcmpV6Type.ECHO_REQUEST).code(IcmpV6Code.NO_CODE).srcAddr(srcAddr).dstAddr(dstAddr).payloadBuilder((Packet.Builder)echob).correctChecksumAtBuild(true);
        IpV6Packet.Builder ipv6b = new IpV6Packet.Builder();
        ipv6b.version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.ICMPV6).hopLimit((byte)100).srcAddr(srcAddr).dstAddr(dstAddr).correctLengthAtBuild(true).payloadBuilder((Packet.Builder)icmpV6b);
        IcmpV6ParameterProblemPacket.Builder b = new IcmpV6ParameterProblemPacket.Builder();
        b.pointer(this.pointer).payload((Packet)ipv6b.build());
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        Inet6Address dstAddr;
        Inet6Address srcAddr;
        try {
            srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
            dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        IcmpV6CommonPacket.Builder icmpV6b = new IcmpV6CommonPacket.Builder();
        icmpV6b.type(IcmpV6Type.PARAMETER_PROBLEM).code(IcmpV6Code.UNRECOGNIZED_IP_V6_OPT).srcAddr(srcAddr).dstAddr(dstAddr).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)this.packet)).correctChecksumAtBuild(true);
        IpV6Packet.Builder ipv6b = new IpV6Packet.Builder();
        ipv6b.version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.ICMPV6).hopLimit((byte)100).srcAddr(srcAddr).dstAddr(dstAddr).correctLengthAtBuild(true).payloadBuilder((Packet.Builder)icmpV6b);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV6).payloadBuilder((Packet.Builder)ipv6b).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IcmpV6ParameterProblemPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        IcmpV6ParameterProblemPacket p;
        try {
            p = IcmpV6ParameterProblemPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
        Assert.assertEquals((Object)this.packet, (Object)p);
        Assert.assertTrue((boolean)p.getPayload().contains(IpV6Packet.class));
        Assert.assertTrue((boolean)p.getPayload().contains(IcmpV6CommonPacket.class));
        Assert.assertTrue((boolean)p.getPayload().contains(IcmpV6EchoRequestPacket.class));
        Assert.assertTrue((boolean)p.getPayload().contains(UnknownPacket.class));
        Assert.assertEquals((long)((UnknownPacket)p.getPayload().get(UnknownPacket.class)).length(), (long)3L);
        Assert.assertFalse((boolean)p.getPayload().contains(IllegalPacket.class));
    }

    @Test
    public void testGetHeader() {
        IcmpV6ParameterProblemPacket.IcmpV6ParameterProblemHeader h = this.packet.getHeader();
        Assert.assertEquals((long)this.pointer, (long)h.getPointer());
        IcmpV6ParameterProblemPacket.Builder b = this.packet.getBuilder();
        b.pointer(0);
        IcmpV6ParameterProblemPacket p = b.build();
        Assert.assertEquals((long)0L, (long)((int)p.getHeader().getPointerAsLong()));
        b.pointer(Integer.MAX_VALUE);
        p = b.build();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)((int)p.getHeader().getPointerAsLong()));
        b.pointer(-1);
        p = b.build();
        Assert.assertEquals((long)-1L, (long)((int)p.getHeader().getPointerAsLong()));
        b.pointer(Integer.MIN_VALUE);
        p = b.build();
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)((int)p.getHeader().getPointerAsLong()));
    }
}

