/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IcmpV6RouterAdvertisementPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6NeighborDiscoveryMtuOption;
import org.pcap4j.packet.IpV6NeighborDiscoveryPrefixInformationOption;
import org.pcap4j.packet.IpV6NeighborDiscoverySourceLinkLayerAddressOption;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IcmpV6Code;
import org.pcap4j.packet.namednumber.IcmpV6Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpV6RouterAdvertisementPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IcmpV6RouterAdvertisementPacketTest.class);
    private final IcmpV6RouterAdvertisementPacket packet;
    private final byte curHopLimit;
    private final boolean managedAddressConfigurationFlag;
    private final boolean otherConfigurationFlag;
    private final byte reserved;
    private final short routerLifetime;
    private final int reachableTime;
    private final int retransTimer;
    private final List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options = new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>();

    public IcmpV6RouterAdvertisementPacketTest() throws UnknownHostException {
        this.curHopLimit = (byte)123;
        this.managedAddressConfigurationFlag = true;
        this.otherConfigurationFlag = false;
        this.reserved = (byte)10;
        this.routerLifetime = (short)-9981;
        this.reachableTime = 3333333;
        this.retransTimer = 111111;
        IpV6NeighborDiscoverySourceLinkLayerAddressOption.Builder opt1 = new IpV6NeighborDiscoverySourceLinkLayerAddressOption.Builder();
        opt1.linkLayerAddress(new byte[]{-1, 0, 0, 1, 2, 3}).correctLengthAtBuild(true);
        this.options.add((IcmpV6CommonPacket.IpV6NeighborDiscoveryOption)opt1.build());
        IpV6NeighborDiscoveryMtuOption.Builder opt2 = new IpV6NeighborDiscoveryMtuOption.Builder();
        opt2.reserved((short)-34).mtu(9999999).correctLengthAtBuild(true);
        this.options.add((IcmpV6CommonPacket.IpV6NeighborDiscoveryOption)opt2.build());
        IpV6NeighborDiscoveryPrefixInformationOption.Builder opt3 = new IpV6NeighborDiscoveryPrefixInformationOption.Builder();
        opt3.prefixLength((byte)96).onLinkFlag(true).addressConfigurationFlag(false).reserved1((byte)22).validLifetime(2222222).preferredLifetime(777777777).reserved2(1212121212).prefix((Inet6Address)InetAddress.getByName("2001:db8::aaaa:bbbb:0:0")).correctLengthAtBuild(true);
        this.options.add((IcmpV6CommonPacket.IpV6NeighborDiscoveryOption)opt3.build());
        IcmpV6RouterAdvertisementPacket.Builder b = new IcmpV6RouterAdvertisementPacket.Builder();
        b.curHopLimit(this.curHopLimit).managedAddressConfigurationFlag(this.managedAddressConfigurationFlag).otherConfigurationFlag(this.otherConfigurationFlag).reserved(this.reserved).routerLifetime(this.routerLifetime).reachableTime(this.reachableTime).retransTimer(this.retransTimer).options(this.options);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        Inet6Address dstAddr;
        Inet6Address srcAddr;
        try {
            srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
            dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        IcmpV6CommonPacket.Builder icmpV6b = new IcmpV6CommonPacket.Builder();
        icmpV6b.type(IcmpV6Type.ROUTER_ADVERTISEMENT).code(IcmpV6Code.NO_CODE).srcAddr(srcAddr).dstAddr(dstAddr).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)this.packet)).correctChecksumAtBuild(true);
        IpV6Packet.Builder ipv6b = new IpV6Packet.Builder();
        ipv6b.version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.ICMPV6).hopLimit((byte)100).srcAddr(srcAddr).dstAddr(dstAddr).correctLengthAtBuild(true).payloadBuilder((Packet.Builder)icmpV6b);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV6).payloadBuilder((Packet.Builder)ipv6b).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IcmpV6RouterAdvertisementPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            IcmpV6RouterAdvertisementPacket p = IcmpV6RouterAdvertisementPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        IcmpV6RouterAdvertisementPacket.IcmpV6RouterAdvertisementHeader h = this.packet.getHeader();
        Assert.assertEquals((long)this.curHopLimit, (long)h.getCurHopLimit());
        Assert.assertEquals((Object)this.managedAddressConfigurationFlag, (Object)h.getManagedAddressConfigurationFlag());
        Assert.assertEquals((Object)this.otherConfigurationFlag, (Object)h.getOtherConfigurationFlag());
        Assert.assertEquals((long)this.reserved, (long)h.getReserved());
        Assert.assertEquals((long)this.routerLifetime, (long)h.getRouterLifetime());
        Assert.assertEquals((long)this.reachableTime, (long)h.getReachableTime());
        Assert.assertEquals((long)this.retransTimer, (long)h.getRetransTimer());
        Iterator iter = h.getOptions().iterator();
        for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption expected : this.options) {
            IcmpV6CommonPacket.IpV6NeighborDiscoveryOption actual = (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption)iter.next();
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        IcmpV6RouterAdvertisementPacket.Builder b = this.packet.getBuilder();
        b.reserved((byte)0);
        IcmpV6RouterAdvertisementPacket p = b.build();
        Assert.assertEquals((long)0L, (long)p.getHeader().getReserved());
        b.reserved((byte)63);
        p = b.build();
        Assert.assertEquals((long)63L, (long)p.getHeader().getReserved());
        b.reserved((byte)64);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        b.reserved((byte)-1);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        b.reserved((byte)1);
        b.curHopLimit((byte)0);
        b.routerLifetime((short)0);
        b.reachableTime(0);
        b.retransTimer(0);
        p = b.build();
        Assert.assertEquals((long)0L, (long)((byte)p.getHeader().getCurHopLimitAsInt()));
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getRouterLifetimeAsInt()));
        Assert.assertEquals((long)0L, (long)((int)p.getHeader().getReachableTimeAsLong()));
        Assert.assertEquals((long)0L, (long)((int)p.getHeader().getRetransTimerAsLong()));
        b.curHopLimit((byte)127);
        b.routerLifetime((short)Short.MAX_VALUE);
        b.reachableTime(Integer.MAX_VALUE);
        b.retransTimer(Integer.MAX_VALUE);
        p = b.build();
        Assert.assertEquals((long)127L, (long)((byte)p.getHeader().getCurHopLimitAsInt()));
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getRouterLifetimeAsInt()));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)((int)p.getHeader().getReachableTimeAsLong()));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)((int)p.getHeader().getRetransTimerAsLong()));
        b.curHopLimit((byte)-1);
        b.routerLifetime((short)-1);
        b.reachableTime(-1);
        b.retransTimer(-1);
        p = b.build();
        Assert.assertEquals((long)-1L, (long)((byte)p.getHeader().getCurHopLimitAsInt()));
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getRouterLifetimeAsInt()));
        Assert.assertEquals((long)-1L, (long)((int)p.getHeader().getReachableTimeAsLong()));
        Assert.assertEquals((long)-1L, (long)((int)p.getHeader().getRetransTimerAsLong()));
        b.curHopLimit((byte)-128);
        b.routerLifetime((short)Short.MIN_VALUE);
        b.reachableTime(Integer.MIN_VALUE);
        b.retransTimer(Integer.MIN_VALUE);
        p = b.build();
        Assert.assertEquals((long)-128L, (long)((byte)p.getHeader().getCurHopLimitAsInt()));
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getRouterLifetimeAsInt()));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)((int)p.getHeader().getReachableTimeAsLong()));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)((int)p.getHeader().getRetransTimerAsLong()));
    }
}

