/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.StringReader;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.FragmentedPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtFragmentPacket;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.UdpPort;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpV6ExtFragmentPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IpV6ExtFragmentPacketTest.class);
    private final IpNumber nextHeader = IpNumber.UDP;
    private final byte reserved = (byte)99;
    private final short fragmentOffset;
    private final byte res;
    private final boolean m;
    private final int identification;
    private final IpV6ExtFragmentPacket packet1;
    private final IpV6ExtFragmentPacket packet2;
    private final Inet6Address srcAddr;
    private final Inet6Address dstAddr;

    public IpV6ExtFragmentPacketTest() throws Exception {
        this.fragmentOffset = 0;
        this.res = 1;
        this.m = true;
        this.identification = 654321;
        try {
            this.srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
            this.dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder();
        unknownb.rawData(new byte[]{0, 1, 2, 3, 4, 5, 6, 7});
        UdpPacket.Builder udpb = new UdpPacket.Builder();
        udpb.dstPort(UdpPort.getInstance((Short)0)).srcPort(UdpPort.SNMP_TRAP).dstAddr((InetAddress)this.dstAddr).srcAddr((InetAddress)this.srcAddr).payloadBuilder((Packet.Builder)unknownb).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        byte[] rawPayload = udpb.build().getRawData();
        IpV6ExtFragmentPacket.Builder b = new IpV6ExtFragmentPacket.Builder();
        b.nextHeader(this.nextHeader).reserved(this.reserved).fragmentOffset(this.fragmentOffset).res(this.res).m(this.m).identification(this.identification).payloadBuilder((Packet.Builder)new FragmentedPacket.Builder().rawData(ByteArrays.getSubArray((byte[])rawPayload, (int)0, (int)8)));
        this.packet1 = b.build();
        b.fragmentOffset((short)1).m(false).payloadBuilder((Packet.Builder)new FragmentedPacket.Builder().rawData(ByteArrays.getSubArray((byte[])rawPayload, (int)8, (int)8)));
        this.packet2 = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet1;
    }

    @Override
    protected Packet getWholePacket() {
        throw new UnsupportedOperationException();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IpV6ExtFragmentPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            IpV6ExtFragmentPacket p = IpV6ExtFragmentPacket.newPacket((byte[])this.packet1.getRawData(), (int)0, (int)this.packet1.getRawData().length);
            Assert.assertEquals((Object)this.packet1, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        IpV6ExtFragmentPacket.IpV6ExtFragmentHeader h = this.packet1.getHeader();
        Assert.assertEquals((Object)this.nextHeader, (Object)h.getNextHeader());
        Assert.assertEquals((long)this.reserved, (long)h.getReserved());
        Assert.assertEquals((long)this.fragmentOffset, (long)h.getFragmentOffset());
        Assert.assertEquals((long)this.res, (long)h.getRes());
        Assert.assertEquals((Object)this.m, (Object)h.getM());
        Assert.assertEquals((long)this.identification, (long)h.getIdentification());
    }

    @Override
    @Test
    public void testToString() throws Exception {
        String line;
        FileReader fr = new FileReader(this.resourceDirPath + "/" + this.getClass().getSimpleName() + ".log");
        BufferedReader fbr = new BufferedReader(fr);
        StringReader sr = new StringReader(this.packet1.toString());
        BufferedReader sbr = new BufferedReader(sr);
        while ((line = sbr.readLine()) != null) {
            Assert.assertEquals((Object)fbr.readLine(), (Object)line);
        }
        sr.close();
        sbr.close();
        sr = new StringReader(this.packet2.toString());
        sbr = new BufferedReader(sr);
        while ((line = sbr.readLine()) != null) {
            Assert.assertEquals((Object)fbr.readLine(), (Object)line);
        }
        Assert.assertNull((Object)sbr.readLine());
        fbr.close();
        fr.close();
        sr.close();
        sbr.close();
    }

    @Override
    @Test
    public void testDump() throws Exception {
        int size;
        String dumpFile = this.tmpDirPath + "/" + this.getClass().getSimpleName() + ".pcap";
        IpV6Packet.Builder ipV6b = new IpV6Packet.Builder();
        ipV6b.version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.IPV6_FRAG).hopLimit((byte)100).srcAddr(this.srcAddr).dstAddr(this.dstAddr).payloadBuilder((Packet.Builder)this.packet1.getBuilder()).correctLengthAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV6).payloadBuilder((Packet.Builder)ipV6b).paddingAtBuild(true);
        EthernetPacket ep1 = eb.build();
        ipV6b.payloadBuilder((Packet.Builder)this.packet2.getBuilder());
        EthernetPacket ep2 = eb.build();
        PcapHandle handle = Pcaps.openDead((DataLinkType)DataLinkType.EN10MB, (int)65536);
        PcapDumper dumper = handle.dumpOpen(dumpFile);
        Timestamp ts = new Timestamp(0L);
        dumper.dump((Packet)ep1, ts);
        dumper.dump((Packet)ep2, ts);
        dumper.close();
        handle.close();
        PcapHandle reader = Pcaps.openOffline((String)dumpFile);
        Assert.assertEquals((Object)ep1, (Object)reader.getNextPacket());
        Assert.assertEquals((Object)ep2, (Object)reader.getNextPacket());
        reader.close();
        FileInputStream in1 = new FileInputStream(this.resourceDirPath + "/" + this.getClass().getSimpleName() + ".pcap");
        FileInputStream in2 = new FileInputStream(dumpFile);
        byte[] buffer1 = new byte[100];
        byte[] buffer2 = new byte[100];
        while ((size = in1.read(buffer1)) != -1) {
            Assert.assertEquals((long)size, (long)in2.read(buffer2));
            Assert.assertArrayEquals((byte[])buffer1, (byte[])buffer2);
        }
        in1.close();
        in2.close();
    }
}

