/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtHopByHopOptionsPacket;
import org.pcap4j.packet.IpV6ExtOptionsPacket;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6Pad1Option;
import org.pcap4j.packet.IpV6PadNOption;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.UdpPort;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpV6ExtHopByHopOptionsPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IpV6ExtHopByHopOptionsPacketTest.class);
    private final IpNumber nextHeader = IpNumber.UDP;
    private final byte hdrExtLen;
    private final List<IpV6ExtOptionsPacket.IpV6Option> options = new ArrayList<IpV6ExtOptionsPacket.IpV6Option>();
    private final IpV6ExtHopByHopOptionsPacket packet;
    private final Inet6Address srcAddr;
    private final Inet6Address dstAddr;

    public IpV6ExtHopByHopOptionsPacketTest() throws Exception {
        this.hdrExtLen = 0;
        this.options.add((IpV6ExtOptionsPacket.IpV6Option)IpV6Pad1Option.getInstance());
        this.options.add((IpV6ExtOptionsPacket.IpV6Option)new IpV6PadNOption.Builder().data(new byte[]{0, 0, 0}).dataLen((byte)3).build());
        try {
            this.srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
            this.dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        UnknownPacket.Builder anonb = new UnknownPacket.Builder();
        anonb.rawData(new byte[]{0, 1, 2, 3});
        UdpPacket.Builder udpb = new UdpPacket.Builder();
        udpb.dstPort(UdpPort.getInstance((Short)0)).srcPort(UdpPort.SNMP_TRAP).dstAddr((InetAddress)this.dstAddr).srcAddr((InetAddress)this.srcAddr).payloadBuilder((Packet.Builder)anonb).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        IpV6ExtHopByHopOptionsPacket.Builder b = new IpV6ExtHopByHopOptionsPacket.Builder();
        b.nextHeader(this.nextHeader).hdrExtLen(this.hdrExtLen).options(this.options).correctLengthAtBuild(false).payloadBuilder((Packet.Builder)udpb);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        IpV6Packet.Builder IpV6b = new IpV6Packet.Builder();
        IpV6b.version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.IPV6_HOPOPT).hopLimit((byte)100).srcAddr(this.srcAddr).dstAddr(this.dstAddr).payloadBuilder((Packet.Builder)this.packet.getBuilder()).correctLengthAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV6).payloadBuilder((Packet.Builder)IpV6b).paddingAtBuild(true);
        ((UdpPacket.Builder)eb.get(UdpPacket.Builder.class)).dstAddr((InetAddress)this.dstAddr).srcAddr((InetAddress)this.srcAddr);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IpV6ExtHopByHopOptionsPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            IpV6ExtHopByHopOptionsPacket p = IpV6ExtHopByHopOptionsPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        IpV6ExtHopByHopOptionsPacket.IpV6ExtHopByHopOptionsHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.nextHeader, (Object)h.getNextHeader());
        Assert.assertEquals((long)this.hdrExtLen, (long)h.getHdrExtLen());
        Assert.assertEquals((long)this.options.size(), (long)h.getOptions().size());
        Iterator iter = h.getOptions().iterator();
        for (IpV6ExtOptionsPacket.IpV6Option opt : this.options) {
            Assert.assertEquals((Object)opt, iter.next());
        }
        IpV6ExtHopByHopOptionsPacket.Builder b = this.packet.getBuilder();
        b.hdrExtLen((byte)0);
        IpV6ExtHopByHopOptionsPacket p = b.build();
        Assert.assertEquals((long)0L, (long)((byte)p.getHeader().getHdrExtLenAsInt()));
        b.hdrExtLen((byte)-1);
        p = b.build();
        Assert.assertEquals((long)-1L, (long)((byte)p.getHeader().getHdrExtLenAsInt()));
        b.hdrExtLen((byte)127);
        p = b.build();
        Assert.assertEquals((long)127L, (long)((byte)p.getHeader().getHdrExtLenAsInt()));
        b.hdrExtLen((byte)-128);
        p = b.build();
        Assert.assertEquals((long)-128L, (long)((byte)p.getHeader().getHdrExtLenAsInt()));
    }
}

