/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LinuxSllPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.namednumber.ArpHardwareType;
import org.pcap4j.packet.namednumber.ArpOperation;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.LinuxSllPacketType;
import org.pcap4j.util.LinkLayerAddress;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxSllPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(LinuxSllPacketTest.class);
    private final LinuxSllPacket packet;
    private final LinuxSllPacketType packetType = LinuxSllPacketType.LINUX_SLL_HOST;
    private final ArpHardwareType hardwareType = ArpHardwareType.ETHERNET;
    private final short hardwareLength = (short)4;
    private final byte[] addressField = new byte[]{-1, -18, -35, -52, 17, 34, 51, 68};
    private final LinkLayerAddress address = LinkLayerAddress.getByAddress((byte[])new byte[]{-1, -18, -35, -52});
    private final EtherType protocol = EtherType.ARP;

    public LinuxSllPacketTest() {
        ArpPacket.Builder ab = new ArpPacket.Builder();
        try {
            ab.hardwareType(ArpHardwareType.ETHERNET).protocolType(EtherType.IPV4).hardwareAddrLength((byte)6).protocolAddrLength((byte)4).srcHardwareAddr(MacAddress.getByName((String)"aa:bb:cc:dd:ee:ff")).dstHardwareAddr(MacAddress.getByName((String)"11:22:33:44:55:66")).srcProtocolAddr(InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).dstProtocolAddr(InetAddress.getByAddress(new byte[]{-64, 0, 2, 2})).operation(ArpOperation.REQUEST);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        LinuxSllPacket.Builder eb = new LinuxSllPacket.Builder();
        eb.packetType(this.packetType).addressType(this.hardwareType).addressLength(this.hardwareLength).address(this.addressField).protocol(this.protocol).payloadBuilder((Packet.Builder)ab);
        this.packet = eb.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        return this.packet;
    }

    @Override
    protected DataLinkType getDataLinkType() {
        return DataLinkType.LINUX_SLL;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + LinuxSllPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            LinuxSllPacket p = LinuxSllPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        LinuxSllPacket.LinuxSllHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.packetType, (Object)h.getPacketType());
        Assert.assertEquals((Object)this.hardwareType, (Object)h.getAddressType());
        Assert.assertEquals((long)this.hardwareLength, (long)h.getAddressLength());
        Assert.assertEquals((Object)this.address, (Object)h.getAddress());
        Assert.assertArrayEquals((byte[])this.addressField, (byte[])h.getAddressField());
        Assert.assertEquals((Object)this.protocol, (Object)h.getProtocol());
    }
}

