/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LlcControlSupervisory;
import org.pcap4j.packet.LlcPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.LlcControlSupervisoryFunction;
import org.pcap4j.packet.namednumber.LlcNumber;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlcSupervisoryPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(LlcSupervisoryPacketTest.class);
    private final LlcPacket packet;
    private final LlcNumber dsap;
    private final LlcNumber ssap;
    private final LlcPacket.LlcControl control;

    public LlcSupervisoryPacketTest() {
        this.dsap = this.ssap = LlcNumber.NULL_LSAP;
        this.control = new LlcControlSupervisory.Builder().receiveSequenceNumber((byte)127).reserved((byte)10).supervisoryFunction(LlcControlSupervisoryFunction.REJ).pfBit(false).build();
        LlcPacket.Builder db = new LlcPacket.Builder();
        db.dsap(this.dsap).ssap(this.ssap).control(this.control);
        this.packet = db.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"aa:bb:cc:dd:ee:ff")).srcAddr(MacAddress.getByName((String)"11:22:33:44:55:66")).type(EtherType.getInstance((Short)((short)this.packet.length()))).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)this.packet)).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + LlcSupervisoryPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            LlcPacket p = LlcPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        LlcPacket.LlcHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.dsap, (Object)h.getDsap());
        Assert.assertEquals((Object)this.ssap, (Object)h.getSsap());
        Assert.assertEquals((Object)this.control, (Object)h.getControl());
    }
}

