/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.RandomPacketTester;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.UdpPort;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(UdpPacketTest.class);
    private final UdpPort srcPort = UdpPort.SNMP;
    private final UdpPort dstPort = UdpPort.getInstance((Short)0);
    private final short length = (short)12;
    private final short checksum = (short)-21555;
    private final Inet6Address srcAddr;
    private final Inet6Address dstAddr;
    private final UdpPacket packet;

    public UdpPacketTest() throws Exception {
        try {
            this.srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
            this.dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder();
        unknownb.rawData(new byte[]{0, 1, 2, 3});
        UdpPacket.Builder b = new UdpPacket.Builder();
        b.dstPort(this.dstPort).srcPort(this.srcPort).length(this.length).checksum(this.checksum).correctChecksumAtBuild(false).correctLengthAtBuild(false).payloadBuilder((Packet.Builder)unknownb);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        IpV6Packet.Builder IpV6b = new IpV6Packet.Builder();
        IpV6b.version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.UDP).hopLimit((byte)100).srcAddr(this.srcAddr).dstAddr(this.dstAddr).payloadBuilder((Packet.Builder)this.packet.getBuilder().correctChecksumAtBuild(true).correctLengthAtBuild(true)).correctLengthAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV6).payloadBuilder((Packet.Builder)IpV6b).paddingAtBuild(true);
        ((UdpPacket.Builder)eb.get(UdpPacket.Builder.class)).dstAddr((InetAddress)this.dstAddr).srcAddr((InetAddress)this.srcAddr);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + UdpPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            UdpPacket p = UdpPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testNewPacketRandom() {
        RandomPacketTester.testClass(UdpPacket.class, (Packet)this.packet);
    }

    @Test
    public void testGetHeader() {
        UdpPacket.UdpHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.srcPort, (Object)h.getSrcPort());
        Assert.assertEquals((Object)this.dstPort, (Object)h.getDstPort());
        Assert.assertEquals((long)this.length, (long)h.getLength());
        Assert.assertEquals((long)this.checksum, (long)h.getChecksum());
        UdpPacket.Builder b = this.packet.getBuilder();
        b.length((short)0);
        UdpPacket p = b.build();
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getLengthAsInt()));
        b.length((short)-1);
        p = b.build();
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getLengthAsInt()));
        b.length((short)Short.MAX_VALUE);
        p = b.build();
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getLengthAsInt()));
        b.length((short)Short.MIN_VALUE);
        p = b.build();
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getLengthAsInt()));
    }

    @Test
    public void testHasValidChecksum() {
        UdpPacket.Builder b = this.packet.getBuilder();
        b.srcAddr((InetAddress)this.srcAddr).dstAddr((InetAddress)this.dstAddr);
        UdpPacket p = b.correctChecksumAtBuild(false).build();
        Assert.assertFalse((boolean)this.packet.hasValidChecksum((InetAddress)this.srcAddr, (InetAddress)this.dstAddr, false));
        Assert.assertFalse((boolean)this.packet.hasValidChecksum((InetAddress)this.srcAddr, (InetAddress)this.dstAddr, true));
        b.checksum((short)0).correctChecksumAtBuild(false);
        p = b.build();
        Assert.assertFalse((boolean)p.hasValidChecksum((InetAddress)this.srcAddr, (InetAddress)this.dstAddr, false));
        Assert.assertTrue((boolean)p.hasValidChecksum((InetAddress)this.srcAddr, (InetAddress)this.dstAddr, true));
        b.correctChecksumAtBuild(true);
        p = b.build();
        Assert.assertTrue((boolean)p.hasValidChecksum((InetAddress)this.srcAddr, (InetAddress)this.dstAddr, false));
        Assert.assertTrue((boolean)p.hasValidChecksum((InetAddress)this.srcAddr, (InetAddress)this.dstAddr, true));
    }

    @Test
    public void testHasValidChecksumFFFF() throws Exception {
        PcapHandle pcapHandle = Pcaps.openOffline((String)this.resourceDirPath.concat("/UdpPacketTestChecksum0xFFFF.pcap"));
        Packet packet = pcapHandle.getNextPacket();
        Assert.assertNotNull((Object)packet);
        Assert.assertTrue((boolean)packet.contains(IpV4Packet.class));
        IpV4Packet ipV4Packet = (IpV4Packet)packet.get(IpV4Packet.class);
        Assert.assertNotNull((Object)ipV4Packet);
        IpV4Packet.IpV4Header ipV4Header = ipV4Packet.getHeader();
        Assert.assertNotNull((Object)ipV4Header);
        Assert.assertTrue((boolean)ipV4Packet.contains(UdpPacket.class));
        UdpPacket udpPacket = (UdpPacket)ipV4Packet.get(UdpPacket.class);
        Assert.assertNotNull((Object)udpPacket);
        Assert.assertEquals((long)-1L, (long)udpPacket.getHeader().getChecksum());
        Assert.assertTrue((boolean)udpPacket.hasValidChecksum((InetAddress)ipV4Header.getSrcAddr(), (InetAddress)ipV4Header.getDstAddr(), false));
    }
}

