/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IcmpV4CommonPacket;
import org.pcap4j.packet.IcmpV4EchoPacket;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IcmpV4Code;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.util.IpV4Helper;
import org.pcap4j.util.MacAddress;

public class IpV4HelperTest {
    private String resourceDir;
    private String tmpDirPath;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.resourceDir = System.getProperty(AbstractPacketTest.RESOURCE_DIR_PROP, "src/test/resources");
        this.tmpDirPath = System.getProperty(AbstractPacketTest.TMP_DIR_PROP, "testdata");
        File tmpDir = new File(this.tmpDirPath);
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException("Failed to make a test diectory: " + this.tmpDirPath);
        }
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testFragmentDefragment() throws Exception {
        int size;
        String dumpFile = this.tmpDirPath + "/" + this.getClass().getSimpleName() + ".pcap";
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder();
        unknownb.rawData(new byte[4000]);
        IcmpV4EchoPacket.Builder echob = new IcmpV4EchoPacket.Builder();
        echob.identifier((short)1234).sequenceNumber((short)4321).payloadBuilder((Packet.Builder)unknownb);
        IcmpV4CommonPacket.Builder icmpV4b = new IcmpV4CommonPacket.Builder();
        icmpV4b.type(IcmpV4Type.ECHO).code(IcmpV4Code.NO_CODE).payloadBuilder((Packet.Builder)echob).correctChecksumAtBuild(true);
        IpV4Packet.Builder ipv4b = new IpV4Packet.Builder();
        ipv4b.version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc1349Tos.newInstance((byte)0)).identification((short)100).ttl((byte)100).protocol(IpNumber.ICMPV4).srcAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).dstAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 2})).payloadBuilder((Packet.Builder)icmpV4b).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV4).payloadBuilder((Packet.Builder)ipv4b).paddingAtBuild(true);
        EthernetPacket orgPacket = eb.build();
        PcapHandle handle = Pcaps.openDead((DataLinkType)DataLinkType.EN10MB, (int)65536);
        PcapDumper dumper = handle.dumpOpen(dumpFile);
        Timestamp ts = new Timestamp(0L);
        dumper.dump((Packet)orgPacket, ts);
        ArrayList<IpV4Packet> list = new ArrayList<IpV4Packet>();
        for (IpV4Packet p : IpV4Helper.fragment((IpV4Packet)((IpV4Packet)orgPacket.getPayload()), (int)987)) {
            EthernetPacket ep = eb.payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)p)).build();
            dumper.dump((Packet)ep, ts);
            list.add(p);
        }
        dumper.close();
        handle.close();
        Collections.shuffle(list);
        Assert.assertEquals((Object)orgPacket, (Object)eb.payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)IpV4Helper.defragment(list))).build());
        FileInputStream in1 = new FileInputStream(this.resourceDir + "/" + this.getClass().getSimpleName() + ".pcap");
        FileInputStream in2 = new FileInputStream(dumpFile);
        byte[] buffer1 = new byte[100];
        byte[] buffer2 = new byte[100];
        while ((size = in1.read(buffer1)) != -1) {
            Assert.assertEquals((long)size, (long)in2.read(buffer2));
            Assert.assertArrayEquals((byte[])buffer1, (byte[])buffer2);
        }
        in1.close();
        in2.close();
    }
}

