// Autogenerated AST node
package org.python.antlr.ast;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.python.antlr.AST;
import org.python.antlr.PythonTree;
import org.python.antlr.adapter.AstAdapters;
import org.python.antlr.base.excepthandler;
import org.python.antlr.base.expr;
import org.python.antlr.base.mod;
import org.python.antlr.base.slice;
import org.python.antlr.base.stmt;
import org.python.core.ArgParser;
import org.python.core.AstList;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.ExposedGet;
import org.python.expose.ExposedMethod;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedSet;
import org.python.expose.ExposedType;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

@ExposedType(name = "_ast.Exec", base = stmt.class)
public class Exec extends stmt {
public static final PyType TYPE = PyType.fromClass(Exec.class);
    private expr body;
    public expr getInternalBody() {
        return body;
    }
    @ExposedGet(name = "body")
    public PyObject getBody() {
        return body;
    }
    @ExposedSet(name = "body")
    public void setBody(PyObject body) {
        this.body = AstAdapters.py2expr(body);
    }

    private expr globals;
    public expr getInternalGlobals() {
        return globals;
    }
    @ExposedGet(name = "globals")
    public PyObject getGlobals() {
        return globals;
    }
    @ExposedSet(name = "globals")
    public void setGlobals(PyObject globals) {
        this.globals = AstAdapters.py2expr(globals);
    }

    private expr locals;
    public expr getInternalLocals() {
        return locals;
    }
    @ExposedGet(name = "locals")
    public PyObject getLocals() {
        return locals;
    }
    @ExposedSet(name = "locals")
    public void setLocals(PyObject locals) {
        this.locals = AstAdapters.py2expr(locals);
    }


    private final static PyString[] fields =
    new PyString[] {new PyString("body"), new PyString("globals"), new PyString("locals")};
    @ExposedGet(name = "_fields")
    public PyString[] get_fields() { return fields; }

    private final static PyString[] attributes =
    new PyString[] {new PyString("lineno"), new PyString("col_offset")};
    @ExposedGet(name = "_attributes")
    public PyString[] get_attributes() { return attributes; }

    public Exec(PyType subType) {
        super(subType);
    }
    public Exec() {
        this(TYPE);
    }
    @ExposedNew
    @ExposedMethod
    public void Exec___init__(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("Exec", args, keywords, new String[]
            {"body", "globals", "locals", "lineno", "col_offset"}, 3, true);
        setBody(ap.getPyObject(0, Py.None));
        setGlobals(ap.getPyObject(1, Py.None));
        setLocals(ap.getPyObject(2, Py.None));
        int lin = ap.getInt(3, -1);
        if (lin != -1) {
            setLineno(lin);
        }

        int col = ap.getInt(4, -1);
        if (col != -1) {
            setLineno(col);
        }

    }

    public Exec(PyObject body, PyObject globals, PyObject locals) {
        setBody(body);
        setGlobals(globals);
        setLocals(locals);
    }

    public Exec(Token token, expr body, expr globals, expr locals) {
        super(token);
        this.body = body;
        addChild(body);
        this.globals = globals;
        addChild(globals);
        this.locals = locals;
        addChild(locals);
    }

    public Exec(Integer ttype, Token token, expr body, expr globals, expr locals) {
        super(ttype, token);
        this.body = body;
        addChild(body);
        this.globals = globals;
        addChild(globals);
        this.locals = locals;
        addChild(locals);
    }

    public Exec(PythonTree tree, expr body, expr globals, expr locals) {
        super(tree);
        this.body = body;
        addChild(body);
        this.globals = globals;
        addChild(globals);
        this.locals = locals;
        addChild(locals);
    }

    @ExposedGet(name = "repr")
    public String toString() {
        return "Exec";
    }

    public String toStringTree() {
        StringBuffer sb = new StringBuffer("Exec(");
        sb.append("body=");
        sb.append(dumpThis(body));
        sb.append(",");
        sb.append("globals=");
        sb.append(dumpThis(globals));
        sb.append(",");
        sb.append("locals=");
        sb.append(dumpThis(locals));
        sb.append(",");
        sb.append(")");
        return sb.toString();
    }

    public <R> R accept(VisitorIF<R> visitor) throws Exception {
        return visitor.visitExec(this);
    }

    public void traverse(VisitorIF<?> visitor) throws Exception {
        if (body != null)
            body.accept(visitor);
        if (globals != null)
            globals.accept(visitor);
        if (locals != null)
            locals.accept(visitor);
    }

    public PyObject __dict__;

    @Override
    public PyObject fastGetDict() {
        ensureDict();
        return __dict__;
    }

    @ExposedGet(name = "__dict__")
    public PyObject getDict() {
        return fastGetDict();
    }

    private void ensureDict() {
        if (__dict__ == null) {
            __dict__ = new PyStringMap();
        }
    }

    private int lineno = -1;
    @ExposedGet(name = "lineno")
    public int getLineno() {
        if (lineno != -1) {
            return lineno;
        }
        return getLine();
    }

    @ExposedSet(name = "lineno")
    public void setLineno(int num) {
        lineno = num;
    }

    private int col_offset = -1;
    @ExposedGet(name = "col_offset")
    public int getCol_offset() {
        if (col_offset != -1) {
            return col_offset;
        }
        return getCharPositionInLine();
    }

    @ExposedSet(name = "col_offset")
    public void setCol_offset(int num) {
        col_offset = num;
    }

}
