/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.rec.fast;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.fast.FastRecommendation;
import es.uam.eps.ir.ranksys.fast.index.FastItemIndex;
import es.uam.eps.ir.ranksys.fast.index.FastUserIndex;
import es.uam.eps.ir.ranksys.rec.AbstractRecommender;
import es.uam.eps.ir.ranksys.rec.fast.FastRecommender;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class AbstractFastRecommender<U, I>
extends AbstractRecommender<U, I>
implements FastRecommender<U, I> {
    protected final FastUserIndex<U> uIndex;
    protected final FastItemIndex<I> iIndex;

    public AbstractFastRecommender(FastUserIndex<U> uIndex, FastItemIndex<I> iIndex) {
        this.uIndex = uIndex;
        this.iIndex = iIndex;
    }

    public int numUsers() {
        return this.uIndex.numUsers();
    }

    public int user2uidx(U u) {
        return this.uIndex.user2uidx(u);
    }

    public U uidx2user(int uidx) {
        return (U)this.uIndex.uidx2user(uidx);
    }

    public int numItems() {
        return this.iIndex.numItems();
    }

    public int item2iidx(I i) {
        return this.iIndex.item2iidx(i);
    }

    public I iidx2item(int iidx) {
        return (I)this.iIndex.iidx2item(iidx);
    }

    @Override
    public Recommendation<U, I> getRecommendation(U u, int maxLength) {
        FastRecommendation rec = this.getRecommendation(this.user2uidx(u), maxLength);
        return new Recommendation(this.uidx2user(rec.getUidx()), rec.getIidxs().stream().map(arg_0 -> ((AbstractFastRecommender)this).iidx2item(arg_0)).collect(Collectors.toList()));
    }

    @Override
    public FastRecommendation getRecommendation(int uidx) {
        return this.getRecommendation(uidx, Integer.MAX_VALUE);
    }

    @Override
    public FastRecommendation getRecommendation(int uidx, int maxLength) {
        return this.getRecommendation(uidx, maxLength, (int iidx) -> true);
    }

    @Override
    public Recommendation<U, I> getRecommendation(U u, int maxLength, Predicate<I> filter) {
        FastRecommendation rec = this.getRecommendation(this.user2uidx(u), maxLength, (int iidx) -> filter.test(this.iidx2item(iidx)));
        return new Recommendation(this.uidx2user(rec.getUidx()), rec.getIidxs().stream().map(arg_0 -> ((AbstractFastRecommender)this).iidx2item(arg_0)).collect(Collectors.toList()));
    }

    @Override
    public FastRecommendation getRecommendation(int uidx, IntPredicate filter) {
        return this.getRecommendation(uidx, Integer.MAX_VALUE, filter);
    }

    @Override
    public abstract FastRecommendation getRecommendation(int var1, int var2, IntPredicate var3);

    @Override
    public Recommendation<U, I> getRecommendation(U u, Stream<I> candidates) {
        FastRecommendation rec = this.getRecommendation(this.user2uidx(u), candidates.mapToInt(this::item2iidx));
        return new Recommendation(this.uidx2user(rec.getUidx()), rec.getIidxs().stream().map(arg_0 -> ((AbstractFastRecommender)this).iidx2item(arg_0)).collect(Collectors.toList()));
    }

    @Override
    public FastRecommendation getRecommendation(int uidx, IntStream candidates) {
        IntOpenHashSet set = new IntOpenHashSet();
        candidates.forEach(arg_0 -> AbstractFastRecommender.lambda$getRecommendation$6((IntSet)set, arg_0));
        return this.getRecommendation(uidx, arg_0 -> AbstractFastRecommender.lambda$getRecommendation$7((IntSet)set, arg_0));
    }

    private static /* synthetic */ boolean lambda$getRecommendation$7(IntSet set, int item) {
        return set.contains(item);
    }

    private static /* synthetic */ void lambda$getRecommendation$6(IntSet set, int iidx) {
        set.add(iidx);
    }
}

