/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.rec.fast;

import es.uam.eps.ir.ranksys.fast.FastRecommendation;
import es.uam.eps.ir.ranksys.fast.index.FastItemIndex;
import es.uam.eps.ir.ranksys.fast.index.FastUserIndex;
import es.uam.eps.ir.ranksys.fast.utils.topn.IntDoubleTopN;
import es.uam.eps.ir.ranksys.rec.fast.AbstractFastRecommender;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;

public abstract class FastRankingRecommender<U, I>
extends AbstractFastRecommender<U, I> {
    public FastRankingRecommender(FastUserIndex<U> uIndex, FastItemIndex<I> iIndex) {
        super(uIndex, iIndex);
    }

    @Override
    public FastRecommendation getRecommendation(int uidx, int maxLength, IntPredicate filter) {
        if (uidx == -1) {
            return new FastRecommendation(uidx, new ArrayList(0));
        }
        Int2DoubleMap scoresMap = this.getScoresMap(uidx);
        IntDoubleTopN topN = new IntDoubleTopN(Math.min(maxLength, scoresMap.size()));
        scoresMap.int2DoubleEntrySet().forEach(e -> {
            int iidx = e.getIntKey();
            double score = e.getDoubleValue();
            if (filter.test(iidx)) {
                topN.add(iidx, score);
            }
        });
        topN.sort();
        List items = topN.reverseStream().collect(Collectors.toList());
        return new FastRecommendation(uidx, items);
    }

    public abstract Int2DoubleMap getScoresMap(int var1);
}

