/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.rec.runner;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.rec.runner.RecommenderRunner;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractRecommenderRunner<U, I>
implements RecommenderRunner<U, I> {
    private static final Logger LOG = Logger.getLogger(AbstractRecommenderRunner.class.getName());
    private final List<U> users;

    public AbstractRecommenderRunner(Stream<U> users) {
        this.users = users.sorted().collect(Collectors.toList());
    }

    @Override
    protected void run(Function<U, Recommendation<U, I>> recProvider, Consumer<Recommendation<U, I>> consumer) {
        this.users.parallelStream().forEach(user -> consumer.accept((Recommendation)recProvider.apply(user)));
    }
}

