/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.rec.runner.fast;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.fast.FastRecommendation;
import es.uam.eps.ir.ranksys.fast.index.FastItemIndex;
import es.uam.eps.ir.ranksys.fast.index.FastUserIndex;
import es.uam.eps.ir.ranksys.rec.Recommender;
import es.uam.eps.ir.ranksys.rec.fast.FastRecommender;
import es.uam.eps.ir.ranksys.rec.runner.AbstractRecommenderRunner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FastFilterRecommenderRunner<U, I>
extends AbstractRecommenderRunner<U, I> {
    private final FastUserIndex<U> userIndex;
    private final FastItemIndex<I> itemIndex;
    private final Function<U, IntPredicate> userFilter;
    private final int maxLength;

    public FastFilterRecommenderRunner(FastUserIndex<U> userIndex, FastItemIndex<I> itemIndex, Stream<U> users, Function<U, IntPredicate> userFilter, int maxLength) {
        super(users);
        this.userIndex = userIndex;
        this.itemIndex = itemIndex;
        this.userFilter = userFilter;
        this.maxLength = maxLength;
    }

    @Override
    public void run(Recommender<U, I> recommender, Consumer<Recommendation<U, I>> consumer) {
        ((AbstractRecommenderRunner)this).run((U user) -> {
            FastRecommendation rec = ((FastRecommender)recommender).getRecommendation(this.userIndex.user2uidx(user), this.maxLength, this.userFilter.apply(user));
            return new Recommendation(this.userIndex.uidx2user(rec.getUidx()), rec.getIidxs().stream().map(arg_0 -> this.itemIndex.iidx2item(arg_0)).collect(Collectors.toList()));
        }, consumer);
    }
}

