/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.beany;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.rapidoid.beany.AnnotatedPropertyFilter;
import org.rapidoid.beany.MapProp;
import org.rapidoid.beany.Prop;
import org.rapidoid.beany.PropertySelector;
import org.rapidoid.cls.Cls;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.u.U;

public class BeanProperties
implements Iterable<Prop> {
    public static BeanProperties NONE = new BeanProperties(Collections.EMPTY_MAP);
    public final Map<String, Prop> map;
    public final List<Prop> props;
    public final List<String> names;
    public final ConcurrentMap<String, Object> extras = U.concurrentMap();
    public final Map<PropertySelector, BeanProperties> selections = U.autoExpandingMap((Mapper)new Mapper<PropertySelector, BeanProperties>(){

        public BeanProperties map(PropertySelector selector) throws Exception {
            Object[] propertyNames = selector.requiredProperties();
            ArrayList<Prop> selected = new ArrayList<Prop>(20);
            if (!U.isEmpty((Object[])propertyNames)) {
                for (Object propName : propertyNames) {
                    Prop prop = BeanProperties.this.map.get(propName);
                    U.must((prop != null ? 1 : 0) != 0, (String)"Cannot find property '%s'!", (Object)propName);
                    if (!Lmbd.eval((Predicate)selector, (Object)prop)) continue;
                    selected.add(prop);
                }
            } else {
                for (Map.Entry<String, Prop> e : BeanProperties.this.map.entrySet()) {
                    if (!Lmbd.eval((Predicate)selector, (Object)e.getValue())) continue;
                    selected.add(e.getValue());
                }
            }
            Collections.sort(selected, selector);
            return BeanProperties.from(selected);
        }
    });

    public BeanProperties(Map<String, ? extends Prop> properties) {
        this.map = Collections.unmodifiableMap(properties);
        this.props = Collections.unmodifiableList(new ArrayList<Prop>(properties.values()));
        this.names = Collections.unmodifiableList(new ArrayList<String>(properties.keySet()));
    }

    @Override
    public Iterator<Prop> iterator() {
        return this.props.iterator();
    }

    public Prop get(String property) {
        return this.map.get(property);
    }

    public BeanProperties select(PropertySelector selector) {
        return this.selections.get(selector);
    }

    public BeanProperties annotated(Class<? extends Annotation> annotated) {
        return this.select(new AnnotatedPropertyFilter(annotated));
    }

    public String toString() {
        return "BeanProperties [map=" + this.map + ", selections=" + this.selections + "]";
    }

    public static BeanProperties from(List<Prop> properties) {
        LinkedHashMap<String, Prop> map = new LinkedHashMap<String, Prop>();
        for (Prop prop : properties) {
            map.put(prop.getName(), prop);
        }
        return new BeanProperties(map);
    }

    public static BeanProperties from(Map<String, ?> map) {
        LinkedHashMap<String, MapProp> properties = new LinkedHashMap<String, MapProp>();
        for (Map.Entry<String, ?> e : map.entrySet()) {
            String key = e.getKey();
            MapProp prop = new MapProp(String.valueOf(key), key, Cls.of(e.getValue()));
            properties.put(prop.getName(), prop);
        }
        return new BeanProperties(properties);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

