/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.benchmark.highlevel;

import org.rapidoid.benchmark.common.Message;
import org.rapidoid.benchmark.highlevel.FortunesHandler;
import org.rapidoid.config.Conf;
import org.rapidoid.env.Env;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.ReqRespHandler;
import org.rapidoid.jdbc.JDBC;
import org.rapidoid.jdbc.JdbcClient;
import org.rapidoid.log.Log;
import org.rapidoid.setup.App;
import org.rapidoid.setup.On;

public class Main {
    public static void main(String[] args) {
        App.run((String[])args, (String[])new String[0]);
        Conf.C3P0.set("maxPoolSize", (Object)256);
        Conf.C3P0.set("maxIdleTimeExcessConnections", (Object)256);
        Conf.C3P0.set("maxStatementsPerConnection", (Object)3);
        Conf.HTTP.set("maxPipeline", (Object)128);
        Conf.HTTP.set("timeout", (Object)0);
        Conf.HTTP.sub(new String[]{"mandatoryHeaders"}).set("connection", (Object)false);
        On.port((int)8080);
        if (Env.hasAnyProfile((String[])new String[]{"mysql", "postgres"})) {
            Main.setupDbHandlers();
        } else {
            Main.setupSimpleHandlers();
        }
    }

    private static void setupSimpleHandlers() {
        On.get((String)"/plaintext").managed(false).contentType(MediaType.TEXT_PLAIN).serve("Hello, world!");
        On.get((String)"/json").managed(false).json(() -> new Message("Hello, world!"));
    }

    private static void setupDbHandlers() {
        String dbHost = (String)Conf.ROOT.entry("dbhost").or((Object)"localhost");
        Log.info((String)("Database hostname is: " + dbHost));
        String dbUrl = Env.hasProfile((String)"mysql") ? "jdbc:mysql://" + dbHost + ":3306/hello_world?" + "useSSL=false&jdbcCompliantTruncation=false&elideSetAutoCommits=true&useLocalSessionState=true&cachePrepStmts=true&cacheCallableStmts=true&alwaysSendSetIsolation=false&prepStmtCacheSize=4096&cacheServerConfiguration=true&prepStmtCacheSqlLimit=2048&zeroDateTimeBehavior=convertToNull&traceProtocol=false&useServerPrepStmts=true&enableQueryTimeouts=false&useUnbufferedIO=false&useReadAheadInput=false&maintainTimeStats=false&cacheRSMetadata=true" : "jdbc:postgresql://" + dbHost + ":5432/hello_world?" + "jdbcCompliantTruncation=false&elideSetAutoCommits=true&useLocalSessionState=true&cachePrepStmts=true&cacheCallableStmts=true&alwaysSendSetIsolation=false&prepStmtCacheSize=4096&cacheServerConfiguration=true&prepStmtCacheSqlLimit=2048&zeroDateTimeBehavior=convertToNull&traceProtocol=false&useServerPrepStmts=true&enableQueryTimeouts=false&useUnbufferedIO=false&useReadAheadInput=false&maintainTimeStats=false&cacheRSMetadata=true";
        JdbcClient mysqlJdbc = JDBC.newApi().url(dbUrl).username("benchmarkdbuser").password("benchmarkdbpass").pooled();
        On.get((String)"/fortunes").html((ReqRespHandler)new FortunesHandler(mysqlJdbc));
    }
}

