/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.performance;

import java.io.File;
import java.io.IOException;
import org.rapidoid.RapidoidThing;
import org.rapidoid.io.IO;
import org.rapidoid.performance.BenchmarkRunner;
import org.rapidoid.process.Proc;
import org.rapidoid.process.ProcessHandle;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.u.U;

public class BenchmarkForker
extends RapidoidThing {
    private final String resultsFile;
    private final String plan;
    private final String target;

    public BenchmarkForker(String[] args) {
        try {
            this.resultsFile = File.createTempFile("benchmark", ".txt").getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't create temporary file!", e);
        }
        this.plan = args.length > 0 ? args[0] : "2x3";
        this.target = args.length > 1 ? args[1] : null;
    }

    public void clear() {
        IO.save((String)this.resultsFile, (String)("BENCHMARK plan: " + this.plan + "\n"));
    }

    public ProcessHandle benchmark(Class<?> mainClass, String uri) {
        String classpath = U.join((String)":", (Iterable)ClasspathUtil.getClasspath());
        String runner = BenchmarkRunner.class.getCanonicalName();
        String main = mainClass.getCanonicalName();
        ProcessHandle proc = Proc.printingOutput((boolean)true).linePrefix("[BENCHMARK] ").run(new String[]{"java", "-Dfile.encoding=UTF-8", "-classpath", classpath, runner, main, uri, this.resultsFile, this.plan}).waitFor();
        return proc;
    }

    public void printResults() {
        U.print((Object[])new Object[]{""});
        U.print((Object[])new Object[]{IO.load((String)this.resultsFile)});
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public void benchmark() {
        BenchmarkRunner.benchmark(this.target, this.target, this.resultsFile, this.plan);
    }
}

