/*
 * Decompiled with CFR 0.152.
 */
package keywhiz.hkdf;

import com.sun.crypto.provider.SunJCE;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import keywhiz.hkdf.Hash;

public class Hkdf {
    private static Hash DEFAULT_HASH = Hash.SHA256;
    private static Provider DEFAULT_PROVIDER = new SunJCE();
    private final Hash hash;
    private final Provider provider;

    private Hkdf(Hash hash, Provider provider) {
        this.hash = hash;
        this.provider = provider;
    }

    public static Hkdf usingDefaults() {
        return new Hkdf(DEFAULT_HASH, DEFAULT_PROVIDER);
    }

    public static Hkdf usingHash(Hash hash) {
        return new Hkdf(Objects.requireNonNull(hash), DEFAULT_PROVIDER);
    }

    public static Hkdf usingProvider(Provider provider) {
        return new Hkdf(DEFAULT_HASH, Objects.requireNonNull(provider));
    }

    public SecretKey extract(SecretKey salt, byte[] ikm) {
        Objects.requireNonNull(ikm, "ikm must not be null");
        if (salt == null) {
            salt = new SecretKeySpec(new byte[this.hash.getByteLength()], this.hash.getAlgorithm());
        }
        Mac mac = this.initMac(salt);
        byte[] keyBytes = mac.doFinal(ikm);
        return new SecretKeySpec(keyBytes, this.hash.getAlgorithm());
    }

    public byte[] expand(SecretKey key, byte[] info, int outputLength) {
        Objects.requireNonNull(key, "key must not be null");
        if (outputLength < 1) {
            throw new IllegalArgumentException("outputLength must be positive");
        }
        int hashLen = this.hash.getByteLength();
        if (outputLength > 255 * hashLen) {
            throw new IllegalArgumentException("outputLength must be less than or equal to 255*HashLen");
        }
        if (info == null) {
            info = new byte[]{};
        }
        int n = outputLength % hashLen == 0 ? outputLength / hashLen : outputLength / hashLen + 1;
        byte[] hashRound = new byte[]{};
        ByteBuffer generatedBytes = ByteBuffer.allocate(n * hashLen);
        Mac mac = this.initMac(key);
        for (int roundNum = 1; roundNum <= n; ++roundNum) {
            mac.reset();
            mac.update(hashRound);
            mac.update(info);
            mac.update((byte)roundNum);
            hashRound = mac.doFinal();
            generatedBytes.put(hashRound);
        }
        byte[] result = new byte[outputLength];
        generatedBytes.rewind();
        generatedBytes.get(result, 0, outputLength);
        return result;
    }

    public SecretKey randomSalt() {
        SecureRandom random = new SecureRandom();
        byte[] randBytes = new byte[this.hash.getByteLength()];
        random.nextBytes(randBytes);
        return new SecretKeySpec(randBytes, this.hash.getAlgorithm());
    }

    private Mac initMac(SecretKey key) {
        try {
            Mac mac = Mac.getInstance(this.hash.getAlgorithm(), this.provider);
            mac.init(key);
            return mac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

