/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.commons;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Coll;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;

public class AutoExpandingMap<K, V>
extends RapidoidThing
implements Map<K, V> {
    private final Map<K, V> target = Coll.synchronizedMap();
    private final Mapper<K, V> valueFactory;

    public AutoExpandingMap(Mapper<K, V> valueFactory) {
        this.valueFactory = valueFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        V val = this.target.get(key);
        if (val == null) {
            Map<K, V> map = this.target;
            synchronized (map) {
                val = this.target.get(key);
                if (val == null) {
                    try {
                        val = this.valueFactory.map(key);
                    }
                    catch (Exception e) {
                        throw U.rte((Throwable)e);
                    }
                    this.target.put(key, val);
                }
                return val;
            }
        }
        return val;
    }

    public AutoExpandingMap<K, V> copy() {
        return new AutoExpandingMap<K, V>(this.valueFactory);
    }

    @Override
    public V put(K k, V v) {
        return this.target.put(k, v);
    }

    @Override
    public V remove(Object o) {
        return this.target.remove(o);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.target.putAll(map);
    }

    @Override
    public void clear() {
        this.target.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.target.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.target.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.target.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoExpandingMap other = (AutoExpandingMap)obj;
        return this.target.equals(other.target);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.target.hashCode();
        return result;
    }

    @Override
    public int size() {
        return this.target.size();
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.target.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.target.containsValue(o);
    }

    public String toString() {
        return this.target.toString();
    }
}

