/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.commons;

import java.util.Iterator;
import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.DataItems;

public class PagingIterator
extends RapidoidThing
implements Iterator {
    private final DataItems items;
    private List<?> page;
    private int offset;
    private int pageLength;
    private int index;

    public PagingIterator(DataItems items) {
        this(items, 100);
    }

    public PagingIterator(DataItems items, int pageLength) {
        this.items = items;
        this.pageLength = pageLength;
    }

    @Override
    public boolean hasNext() {
        if (this.page == null || this.index >= this.page.size()) {
            this.page = this.items.page(this.offset, this.pageLength);
            this.offset += this.page.size();
            this.index = 0;
        }
        return this.index < this.page.size();
    }

    public Object next() {
        return this.page.get(this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

