/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Coll;
import org.rapidoid.commons.Env;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigHelp;
import org.rapidoid.config.ConfigUtil;
import org.rapidoid.io.Res;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class Conf
extends RapidoidThing {
    private static final Map<String, Config> SECTIONS = Coll.autoExpandingMap(new Mapper<String, Config>(){

        @Override
        public Config map(String name) throws Exception {
            return Conf.createSection(name);
        }
    });
    public static final Config ROOT = new Config();
    public static final Config USERS = Conf.section("users");
    public static final Config JOBS = Conf.section("jobs");
    public static final Config OAUTH = Conf.section("oauth");
    public static final Config JDBC = Conf.section("jdbc");
    public static final Config HIBERNATE = Conf.section("hibernate");
    public static final Config APP = Conf.section("app");
    public static final Config ON = Conf.section("on");
    public static final Config ADMIN = Conf.section("admin");
    private static volatile String[] args;
    private static volatile String path;

    public static synchronized void args(String ... args) {
        Conf.args = args;
        ConfigHelp.processHelp(args);
        ROOT.args(args);
        Conf.configureProfiles();
        Conf.applyConfig();
        Conf.reload();
        ROOT.args(args);
    }

    private static void applyConfig() {
        String root;
        String appJar;
        if (Env.dev()) {
            Log.setStyled((boolean)true);
        }
        if (U.notEmpty((String)(appJar = APP.entry("jar").str().getOrNull()))) {
            ClasspathUtil.appJar(appJar);
        }
        if (U.notEmpty((String)(root = ROOT.entry("root").str().getOrNull()))) {
            Res.root(root);
        }
    }

    private static void configureProfiles() {
        String profiles = ROOT.entry("profiles").str().getOrNull();
        if (profiles != null) {
            Coll.assign(Env.profiles(), profiles.split("\\s*\\,\\s*"));
            Log.info((String)"Configuring active profiles", (String)"!profiles", Env.profiles());
            Conf.reload();
        } else if (Env.profiles().isEmpty()) {
            Env.profiles().add("default");
            Log.info((String)"No profiles were specified, configuring the 'default' profile", (String)"!profiles", Env.profiles());
            Conf.reload();
        }
    }

    public static synchronized void profiles(String ... profiles) {
        Coll.assign(Env.profiles(), profiles);
        Log.info((String)"Overriding active profiles", (String)"!profiles", Env.profiles());
        Conf.reload();
    }

    public static boolean micro() {
        return ROOT.is("micro");
    }

    public static void reset() {
        ROOT.clear();
        args = new String[0];
    }

    public static Config section(String name) {
        return SECTIONS.get(name);
    }

    private static Config createSection(String name) {
        Config config = ROOT.sub(name);
        ConfigUtil.load(Conf.filename(config.keys()), config);
        return config;
    }

    public static Config section(Class<?> clazz) {
        return Conf.section(clazz.getSimpleName());
    }

    public static int cpus() {
        return ROOT.entry("cpus").or(Runtime.getRuntime().availableProcessors());
    }

    public static void setPath(String path) {
        Conf.path = path;
        Conf.reload();
    }

    public static void reload() {
        List<List<String>> detached = ConfigUtil.untrack();
        Conf.reset();
        ConfigUtil.load(Msc.path("default", "config.y?ml"), ROOT);
        for (String string : Env.profiles()) {
            ConfigUtil.load(Msc.path("default", U.frmt((String)"profile-%s.y?ml", (Object[])new Object[]{string})), ROOT);
        }
        ConfigUtil.load(Msc.path(path, "application.y?ml"), ROOT);
        ConfigUtil.load(Msc.path(path, "config.y?ml"), ROOT);
        for (String string : Env.profiles()) {
            ConfigUtil.load(Msc.path(path, U.frmt((String)"application-%s.y?ml", (Object[])new Object[]{string})), ROOT);
            ConfigUtil.load(Msc.path(path, U.frmt((String)"profile-%s.y?ml", (Object[])new Object[]{string})), ROOT);
        }
        for (Config config : SECTIONS.values()) {
            ConfigUtil.load(Conf.filename(config.keys()), config);
        }
        for (List list : detached) {
            Conf.autoRefresh(list.isEmpty() ? ROOT : ROOT.sub(list));
        }
        ROOT.args(args);
        Conf.applyConfig();
    }

    private static void autoRefresh(Config ... configs) {
        for (Config config : configs) {
            List<String> keys = config.keys();
            ConfigUtil.autoRefresh(config, Conf.filename(keys));
        }
    }

    private static String filename(List<String> keys) {
        U.must((keys.size() < 2 ? 1 : 0) != 0);
        String configName = keys.isEmpty() ? "config" : keys.get(0);
        return Msc.path(path, configName + ".y?ml");
    }

    public static String[] getArgs() {
        return args;
    }

    static {
        Conf.reload();
        path = "";
    }
}

