/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.Arr;
import org.rapidoid.commons.Coll;
import org.rapidoid.config.ConfigAlternatives;
import org.rapidoid.config.ConfigValueStore;
import org.rapidoid.lambda.ToMap;
import org.rapidoid.u.U;
import org.rapidoid.value.Value;
import org.rapidoid.value.Values;

public class Config
extends RapidoidThing
implements ToMap<String, Object> {
    private final Map<String, Object> properties;
    private final List<String> baseKeys;
    private final Config root;
    private final boolean isRoot;

    private Config(Map<String, Object> properties, List<String> baseKeys, Config root) {
        this.properties = properties;
        this.root = root;
        this.baseKeys = Collections.unmodifiableList(U.list(baseKeys));
        this.isRoot = false;
    }

    public Config() {
        this.properties = Coll.synchronizedMap();
        this.root = this;
        this.baseKeys = U.list();
        this.isRoot = true;
    }

    public Value<Object> entry(String key) {
        return Values.wrap(new ConfigValueStore(this, key));
    }

    private List<String> keyChain(Iterator<String> keys) {
        List keyChain = U.list(this.baseKeys);
        while (keys.hasNext()) {
            String key = keys.next();
            U.notNull((Object)key, (String)"config key", (Object[])new Object[0]);
            Collections.addAll(keyChain, key.split("\\."));
        }
        return keyChain;
    }

    public Config sub(String ... keys) {
        U.must((boolean)U.notEmpty((Object[])keys), (String)"Keys must be specified!");
        return new Config(this.properties, this.keyChain(U.iterator((Object[])keys)), this.root());
    }

    public Config sub(List<String> keys) {
        U.must((boolean)U.notEmpty(keys), (String)"Keys must be specified!");
        return new Config(this.properties, this.keyChain(keys.iterator()), this.root());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Object value;
        Map<String, Object> map = this.properties;
        synchronized (map) {
            value = this.asMap().get(key);
        }
        return value != null ? value : this.global(key);
    }

    private String global(String key) {
        String fullKey = this.fullKey(key, ".");
        String value = System.getProperty(fullKey);
        if (value == null) {
            value = System.getenv(fullKey);
        }
        if (value == null) {
            value = System.getenv(this.fullKey(key, "_").toUpperCase());
        }
        if (value == null) {
            value = System.getenv(this.fullKey(key, "_").toLowerCase());
        }
        return value;
    }

    private String fullKey(String key, String separator) {
        return U.join((String)separator, this.baseKeys) + separator + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean has(String key) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            return this.asMap().containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean is(String key) {
        Object value;
        Map<String, Object> map = this.properties;
        synchronized (map) {
            value = this.asMap().get(key);
        }
        return Boolean.TRUE.equals(Cls.convert(value, Boolean.class));
    }

    @Override
    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.asMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> asMap() {
        if (this.isRoot) {
            return this.properties;
        }
        Map<String, Object> map = this.properties;
        synchronized (map) {
            Map<String, Object> props = this.properties;
            for (String key : this.baseKeys) {
                Map value = props.get(key);
                if (value == null) {
                    value = Coll.synchronizedMap();
                    props.put(key, value);
                }
                if (value instanceof Map) {
                    props = value;
                    continue;
                }
                throw U.rte((String)"Expected a Map for configuration section '%s', but found value of type: %s", (Object[])new Object[]{this.sectionTo(key), value.getClass().getSimpleName()});
            }
            return props;
        }
    }

    private String sectionTo(String toKey) {
        String section = "";
        for (String key : this.baseKeys) {
            if (!section.isEmpty()) {
                section = section + ".";
            }
            section = section + key;
            if (!key.equals(toKey)) continue;
            break;
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.isRoot) {
            this.properties.clear();
        } else {
            Map<String, Object> map = this.properties;
            synchronized (map) {
                this.asMap().clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (this.isRoot) {
            this.properties.clear();
        } else {
            Map<String, Object> map = this.properties;
            synchronized (map) {
                this.parent().remove(this.lastBaseKey());
            }
        }
    }

    private String lastBaseKey() {
        return this.baseKeys.get(this.baseKeys.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, Object value) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.asMap().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.asMap().remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(Map<String, Object> entries) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.clear();
            this.update(entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            return this.asMap().isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Map<String, ?> entries) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            Map<String, Object> conf = this.asMap();
            for (Map.Entry<String, ?> e : entries.entrySet()) {
                String name = e.getKey();
                Object value = e.getValue();
                if (value instanceof Map) {
                    this.sub(name).update((Map)value);
                    continue;
                }
                conf.put(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            return this.asMap().toString();
        }
    }

    public void args(String ... args) {
        if (U.notEmpty((Object[])args)) {
            for (String arg : args) {
                String[] parts = arg.split("=", 2);
                if (parts.length > 1) {
                    this.setNested(parts[0], parts[1]);
                    continue;
                }
                this.setNested(parts[0], true);
            }
        }
    }

    private void setNested(String key, Object value) {
        Object[] keys = key.split("\\.");
        Config cfg = keys.length > 1 ? this.sub(Arr.sub(keys, 0, -1)) : this;
        cfg.set((String)U.last((Object[])keys), value);
    }

    public Config root() {
        return this.root;
    }

    public Config parent() {
        return this.isRoot ? null : this.root.sub(this.baseKeys.subList(0, this.baseKeys.size() - 1));
    }

    public List<String> keys() {
        return this.baseKeys;
    }

    public Map<String, String> toFlatMap() {
        Map flatMap = U.map();
        Map<String, Object> map = this.toMap();
        Config.traverseToFlat(map, U.list(this.keys()), flatMap);
        return flatMap;
    }

    private static void traverseToFlat(Map<String, Object> map, List<String> keys, Map<String, String> flatMap) {
        for (Map.Entry<String, Object> e : map.entrySet()) {
            String key = e.getKey();
            Object val = e.getValue();
            if (val instanceof Map) {
                Map mapVal = (Map)val;
                List keys2 = U.list(keys);
                keys2.add(key);
                Config.traverseToFlat(mapVal, keys2, flatMap);
                continue;
            }
            flatMap.put(U.join((String)".", keys) + "." + key, String.valueOf(val));
        }
    }

    public Properties toProperties() {
        Properties props = new Properties();
        props.putAll(this.toFlatMap());
        return props;
    }

    public ConfigAlternatives or(Config alternative) {
        return new ConfigAlternatives(this, alternative);
    }
}

