/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.scan;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.lambda.Operation;
import org.rapidoid.log.Log;
import org.rapidoid.scan.ClasspathUtil;

public class ScanParams
extends RapidoidThing {
    private String[] packages = null;
    private String matching = null;
    private Class<? extends Annotation>[] annotated = null;
    private ClassLoader classLoader = null;

    public synchronized ScanParams in(String ... packages) {
        this.packages = packages;
        return this;
    }

    public synchronized String[] in() {
        return this.packages;
    }

    public synchronized ScanParams matching(String matching) {
        this.matching = matching;
        return this;
    }

    public synchronized String matching() {
        return this.matching;
    }

    public synchronized ScanParams annotated(Class<? extends Annotation> ... annotated) {
        this.annotated = annotated;
        return this;
    }

    public synchronized ScanParams annotated(Collection<Class<? extends Annotation>> annotated) {
        return this.annotated(annotated.toArray(new Class[annotated.size()]));
    }

    public synchronized Class<? extends Annotation>[] annotated() {
        return this.annotated;
    }

    public synchronized ScanParams classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public synchronized ClassLoader classLoader() {
        return this.classLoader;
    }

    public synchronized List<String> getAll() {
        return ClasspathUtil.getClasses(this);
    }

    public synchronized List<Class<?>> loadAll() {
        return ClasspathUtil.loadClasses(this);
    }

    public synchronized void forEach(Operation<Class<?>> classOperation) {
        for (Class<?> cls : this.loadAll()) {
            try {
                classOperation.execute(cls);
            }
            catch (Exception e) {
                Log.error((String)"Cannot process annotated class!", (Throwable)e);
            }
        }
    }
}

