/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.log.Log;
import org.rapidoid.sql.C3P0ConnectionPool;
import org.rapidoid.sql.ConnectionPool;
import org.rapidoid.sql.JDBC;
import org.rapidoid.sql.JDBCConfig;
import org.rapidoid.sql.NoConnectionPool;
import org.rapidoid.u.U;

public class JdbcClient
extends RapidoidThing {
    private boolean initialized;
    private String username;
    private String password;
    private String driver;
    private String url;
    private volatile ConnectionPool pool = new NoConnectionPool();

    public synchronized JdbcClient username(String username) {
        this.username = username;
        this.initialized = false;
        return this;
    }

    public synchronized JdbcClient password(String password) {
        this.password = password;
        this.initialized = false;
        return this;
    }

    public synchronized JdbcClient driver(String driver) {
        this.driver = driver;
        this.initialized = false;
        return this;
    }

    public synchronized JdbcClient pool(ConnectionPool connectionPool) {
        this.pool = connectionPool;
        this.initialized = false;
        return this;
    }

    public synchronized JdbcClient url(String url) {
        this.url = url;
        this.initialized = false;
        return this;
    }

    public JdbcClient mysql(String host, int port, String databaseName) {
        return this.driver("com.mysql.jdbc.Driver").url(U.frmt((String)"jdbc:mysql://%s:%s/%s", (Object[])new Object[]{host, port, databaseName}));
    }

    public JdbcClient h2(String databaseName) {
        return this.driver("org.h2.Driver").url("jdbc:h2:mem:" + databaseName + ";DB_CLOSE_DELAY=-1").username("sa").password("");
    }

    public JdbcClient hsql(String databaseName) {
        return this.driver("org.hsqldb.jdbc.JDBCDriver").url("jdbc:hsqldb:mem:" + databaseName).username("sa").password("");
    }

    private void registerJDBCDriver() {
        if (this.driver == null) {
            this.driver = JDBCConfig.driver();
        }
        this.validateArgNotNull("driver", this.driver);
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find JDBC driver class: " + this.driver);
        }
    }

    private void validateArgNotNull(String argName, String argValue) {
        if (argValue == null) {
            throw new RuntimeException("The JDBC parameter '" + argName + "' must be configured!");
        }
    }

    private synchronized void ensureIsInitialized() {
        if (!this.initialized) {
            this.validate();
            this.registerJDBCDriver();
            String maskedPassword = U.isEmpty((String)this.password) ? "<empty>" : "<specified>";
            Log.info((String)"Initialized the default JDBC API", (String)"!url", (Object)this.url, (String)"!driver", (Object)this.driver, (String)"!username", (Object)this.username, (String)"!password", (Object)maskedPassword);
            this.initialized = true;
        }
    }

    private void validate() {
        U.must((boolean)U.notEmpty((Object)(this.username != null ? 1 : 0)), (String)"The database username must be specified!");
        U.must((boolean)U.notEmpty((Object)(this.password != null ? 1 : 0)), (String)"The database password must be specified!");
        U.must((boolean)U.notEmpty((Object)(this.url != null ? 1 : 0)), (String)"The database connection URL must be specified!");
        U.must((boolean)U.notEmpty((Object)(this.driver != null ? 1 : 0)), (String)"The database driver must be specified!");
    }

    public Connection getConnection() {
        this.ensureIsInitialized();
        return this.provideConnection();
    }

    private static void close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error occured while closing the connection!", e);
        }
    }

    private static void close(PreparedStatement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error occured while closing the statement!", e);
        }
    }

    private static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error occured while closing the ResultSet!", e);
        }
    }

    public void execute(String sql, Object ... args) {
        this.ensureIsInitialized();
        Connection conn = this.provideConnection();
        PreparedStatement stmt = null;
        try {
            stmt = JDBC.prepare(conn, sql, args);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                JdbcClient.close(stmt);
                JdbcClient.close(conn);
                throw throwable;
            }
        }
        JdbcClient.close(stmt);
        JdbcClient.close(conn);
    }

    public void tryToExecute(String sql, Object ... args) {
        try {
            this.execute(sql, args);
        }
        catch (Exception e) {
            Log.warn((String)"Ignoring exception", (String)"error", (Object)U.safe((String)e.getMessage()));
        }
    }

    public <T> List<Map<String, Object>> query(String sql, Object ... args) {
        List<Map<String, Object>> list;
        this.ensureIsInitialized();
        Connection conn = this.provideConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = JDBC.prepare(conn, sql, args);
            rs = stmt.executeQuery();
            list = JDBC.rows(rs);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                JdbcClient.close(rs);
                JdbcClient.close(stmt);
                JdbcClient.close(conn);
                throw throwable;
            }
        }
        JdbcClient.close(rs);
        JdbcClient.close(stmt);
        JdbcClient.close(conn);
        return list;
    }

    private Connection provideConnection() {
        try {
            Connection conn;
            if (this.username != null) {
                String pass = U.safe((String)this.password);
                conn = this.pool.getConnection(this.url, this.username, pass);
                if (conn == null) {
                    conn = DriverManager.getConnection(this.url, this.username, pass);
                }
            } else {
                conn = this.pool.getConnection(this.url);
                if (conn == null) {
                    conn = DriverManager.getConnection(this.url);
                }
            }
            return conn;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot create JDBC connection!", e);
        }
    }

    public void release(Connection connection) {
        try {
            this.pool.releaseConnection(connection);
        }
        catch (SQLException e) {
            Log.error((String)"Error while releasing a JDBC connection!", (Throwable)e);
        }
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String driver() {
        return this.driver;
    }

    public String url() {
        return this.url;
    }

    public ConnectionPool pool() {
        return this.pool;
    }

    public JdbcClient pooled() {
        this.ensureIsInitialized();
        this.pool = new C3P0ConnectionPool(this);
        return this;
    }
}

