/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.beany;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.rapidoid.RapidoidThing;
import org.rapidoid.beany.AnnotatedPropertyFilter;
import org.rapidoid.beany.MapProp;
import org.rapidoid.beany.Prop;
import org.rapidoid.beany.PropertySelector;
import org.rapidoid.cls.Cls;
import org.rapidoid.collection.Coll;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class BeanProperties
extends RapidoidThing
implements Iterable<Prop> {
    public static BeanProperties NONE = new BeanProperties(Collections.EMPTY_MAP);
    public final Map<String, Prop> map;
    public final Map<String, Prop> lowercaseMap;
    public final List<Prop> props;
    public final List<String> names;
    public final ConcurrentMap<String, Object> extras = Coll.concurrentMap();
    public final Map<PropertySelector, BeanProperties> selections = Coll.autoExpandingMap(new Mapper<PropertySelector, BeanProperties>(){

        @Override
        public BeanProperties map(PropertySelector selector) throws Exception {
            Set<String> include = selector.include();
            Set<String> exclude = selector.exclude();
            ArrayList<Prop> selected = new ArrayList<Prop>(10);
            for (String propName : include) {
                Prop prop = BeanProperties.this.map.get(propName);
                U.must((prop != null ? 1 : 0) != 0, (String)"Cannot find property '%s'!", (Object)propName);
                if (BeanProperties.this.veto(prop) || !Lmbd.eval(selector, prop) || !Lmbd.eval(selector, prop)) continue;
                selected.add(prop);
            }
            if (U.notEmpty(exclude) || U.isEmpty(include)) {
                for (Prop prop : BeanProperties.this.map.values()) {
                    if (BeanProperties.this.veto(prop) || selected.contains(prop) || exclude.contains(prop.getName()) || !Lmbd.eval(selector, prop)) continue;
                    selected.add(prop);
                }
            }
            Collections.sort(selected, selector);
            return BeanProperties.from(selected);
        }
    });

    private boolean veto(Prop prop) {
        return prop.getName().equalsIgnoreCase("clone");
    }

    public BeanProperties(Map<String, ? extends Prop> properties) {
        this.map = Collections.unmodifiableMap(properties);
        this.lowercaseMap = Msc.lowercase(this.map);
        this.props = Collections.unmodifiableList(U.list(properties.values()));
        this.names = Collections.unmodifiableList(U.list(properties.keySet()));
    }

    @Override
    public Iterator<Prop> iterator() {
        return this.props.iterator();
    }

    public Prop get(String property) {
        Prop prop = this.map.get(property);
        if (prop == null) {
            prop = this.lowercaseMap.get(property.toLowerCase());
        }
        return prop;
    }

    public BeanProperties select(PropertySelector selector) {
        return this.selections.get(selector);
    }

    public BeanProperties annotated(Class<? extends Annotation> annotated) {
        return this.select(new AnnotatedPropertyFilter(annotated));
    }

    public String toString() {
        return "BeanProperties [map=" + this.map + ", selections=" + this.selections + "]";
    }

    public static BeanProperties from(List<Prop> properties) {
        LinkedHashMap<String, Prop> map = new LinkedHashMap<String, Prop>();
        for (Prop prop : properties) {
            map.put(prop.getName(), prop);
        }
        return new BeanProperties(map);
    }

    public static BeanProperties from(Map<String, ?> map) {
        LinkedHashMap<String, MapProp> properties = new LinkedHashMap<String, MapProp>();
        for (Map.Entry<String, ?> e : map.entrySet()) {
            String key = e.getKey();
            MapProp prop = new MapProp(String.valueOf(key), key, Cls.of(e.getValue()));
            properties.put(prop.getName(), prop);
        }
        return new BeanProperties(properties);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

