/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.Map;
import org.rapidoid.collection.Coll;
import org.rapidoid.config.Config;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class ConfigBase
extends RapidoidInitializer {
    private final String defaultFilenameBase;
    private final boolean useBuiltInDefaults;
    final Map<String, Object> properties = Coll.synchronizedMap();
    final Map<String, Object> args = Coll.synchronizedMap();
    volatile boolean initializing;
    volatile boolean initialized;
    volatile String path = "";
    volatile String filenameBase;

    public ConfigBase(String defaultFilenameBase, boolean useBuiltInDefaults) {
        this.defaultFilenameBase = defaultFilenameBase;
        this.filenameBase = defaultFilenameBase;
        this.useBuiltInDefaults = useBuiltInDefaults;
    }

    synchronized void reset() {
        this.properties.clear();
        this.args.clear();
        this.filenameBase = this.defaultFilenameBase;
        this.path = "";
        this.initialized = false;
        this.initializing = false;
    }

    synchronized void invalidate() {
        this.properties.clear();
        this.initialized = false;
        this.initializing = false;
    }

    String getFilenameBase() {
        return this.filenameBase;
    }

    synchronized boolean setFilenameBase(String filenameBase) {
        if (U.neq((Object)this.filenameBase, (Object)filenameBase)) {
            Log.info((String)"Changing configuration filename base", (String)"!from", (Object)this.filenameBase, (String)"!to", (Object)filenameBase);
            this.filenameBase = filenameBase;
            return true;
        }
        return false;
    }

    boolean setPath(String path) {
        if (U.neq((Object)this.path, (Object)path)) {
            Log.info((String)"Changing configuration path", (String)"!from", (Object)this.path, (String)"!to", (Object)path);
            this.path = path;
            return true;
        }
        return false;
    }

    String getPath() {
        return this.path;
    }

    public boolean useBuiltInDefaults() {
        return this.useBuiltInDefaults;
    }

    void putArg(String name, Object value) {
        this.args.put(name, value);
    }

    void applyArgsTo(Config config) {
        config.updateNested(this.args);
    }
}

