/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.ctx;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.u.U;

public class UserInfo
extends RapidoidThing
implements Serializable {
    private static final long serialVersionUID = 7062732348562440194L;
    public static final UserInfo ANONYMOUS = new UserInfo(null, U.set());
    public final String username;
    public final Set<String> roles;
    public final Map<String, Boolean> is;
    public volatile String email;
    public volatile String name;
    public volatile String oauthId;
    public volatile String oauthProvider;

    public UserInfo(String username, Set<String> roles) {
        this.username = username;
        this.roles = Collections.unmodifiableSet(U.safe(roles));
        this.is = UserInfo.rolesMap(roles);
    }

    private static Map<String, Boolean> rolesMap(Set<String> roles) {
        Map rolesMap = U.map();
        for (String role : U.safe(roles)) {
            rolesMap.put(role, true);
        }
        return Collections.unmodifiableMap(rolesMap);
    }

    public String toString() {
        return "UserInfo{username='" + this.username + '\'' + ", roles=" + this.roles + ", is=" + this.is + ", email='" + this.email + '\'' + ", name='" + this.name + '\'' + ", oauthId='" + this.oauthId + '\'' + ", oauthProvider='" + this.oauthProvider + '\'' + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserInfo other = (UserInfo)obj;
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

